/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import com.google.api.client.util.Key;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.firebase.internal.NonNull;
import com.google.firebase.internal.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WebpushNotification {
    private final Map<String, Object> fields;

    public WebpushNotification(String title, String body) {
        this(title, body, null);
    }

    public WebpushNotification(String title, String body, @Nullable String icon) {
        this(WebpushNotification.builder().setTitle(title).setBody(body).setIcon(icon));
    }

    private WebpushNotification(Builder builder) {
        ImmutableMap.Builder<String, Object> fields = ImmutableMap.builder();
        if (!builder.actions.isEmpty()) {
            fields.put("actions", ImmutableList.copyOf(builder.actions));
        }
        WebpushNotification.addNonNullNonEmpty(fields, "badge", builder.badge);
        WebpushNotification.addNonNullNonEmpty(fields, "body", builder.body);
        WebpushNotification.addNonNull(fields, "data", builder.data);
        WebpushNotification.addNonNullNonEmpty(fields, "dir", builder.direction != null ? ((Builder)builder).direction.value : null);
        WebpushNotification.addNonNullNonEmpty(fields, "icon", builder.icon);
        WebpushNotification.addNonNullNonEmpty(fields, "image", builder.image);
        WebpushNotification.addNonNullNonEmpty(fields, "lang", builder.language);
        WebpushNotification.addNonNull(fields, "renotify", builder.renotify);
        WebpushNotification.addNonNull(fields, "requireInteraction", builder.requireInteraction);
        WebpushNotification.addNonNull(fields, "silent", builder.silent);
        WebpushNotification.addNonNullNonEmpty(fields, "tag", builder.tag);
        WebpushNotification.addNonNull(fields, "timestamp", builder.timestampMillis);
        WebpushNotification.addNonNullNonEmpty(fields, "title", builder.title);
        WebpushNotification.addNonNull(fields, "vibrate", builder.vibrate);
        fields.putAll(builder.customData);
        this.fields = fields.build();
    }

    Map<String, Object> getFields() {
        return this.fields;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static void addNonNull(ImmutableMap.Builder<String, Object> fields, String key, Object value) {
        if (value != null) {
            fields.put(key, value);
        }
    }

    private static void addNonNullNonEmpty(ImmutableMap.Builder<String, Object> fields, String key, String value) {
        if (!Strings.isNullOrEmpty(value)) {
            fields.put(key, value);
        }
    }

    public static class Builder {
        private final List<Action> actions = new ArrayList<Action>();
        private String badge;
        private String body;
        private Object data;
        private Direction direction;
        private String icon;
        private String image;
        private String language;
        private Boolean renotify;
        private Boolean requireInteraction;
        private Boolean silent;
        private String tag;
        private Long timestampMillis;
        private String title;
        private List<Integer> vibrate;
        private final Map<String, Object> customData = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder addAction(@NonNull Action action) {
            this.actions.add(action);
            return this;
        }

        public Builder addAllActions(@NonNull List<Action> actions) {
            this.actions.addAll(actions);
            return this;
        }

        public Builder setBadge(String badge) {
            this.badge = badge;
            return this;
        }

        public Builder setBody(String body) {
            this.body = body;
            return this;
        }

        public Builder setData(Object data) {
            this.data = data;
            return this;
        }

        public Builder setDirection(Direction direction) {
            this.direction = direction;
            return this;
        }

        public Builder setIcon(String icon) {
            this.icon = icon;
            return this;
        }

        public Builder setImage(String image) {
            this.image = image;
            return this;
        }

        public Builder setLanguage(String language) {
            this.language = language;
            return this;
        }

        public Builder setRenotify(boolean renotify) {
            this.renotify = renotify;
            return this;
        }

        public Builder setRequireInteraction(boolean requireInteraction) {
            this.requireInteraction = requireInteraction;
            return this;
        }

        public Builder setSilent(boolean silent) {
            this.silent = silent;
            return this;
        }

        public Builder setTag(String tag) {
            this.tag = tag;
            return this;
        }

        public Builder setTimestampMillis(long timestampMillis) {
            this.timestampMillis = timestampMillis;
            return this;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setVibrate(int[] pattern) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (int value : pattern) {
                list.add(value);
            }
            this.vibrate = ImmutableList.copyOf(list);
            return this;
        }

        public Builder putCustomData(@NonNull String key, @NonNull Object value) {
            this.customData.put(key, value);
            return this;
        }

        public Builder putAllCustomData(@NonNull Map<String, Object> fields) {
            this.customData.putAll(fields);
            return this;
        }

        public WebpushNotification build() {
            return new WebpushNotification(this);
        }
    }

    public static class Action {
        @Key(value="action")
        private final String action;
        @Key(value="title")
        private final String title;
        @Key(value="icon")
        private final String icon;

        public Action(String action, String title) {
            this(action, title, null);
        }

        public Action(String action, String title, @Nullable String icon) {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(action));
            Preconditions.checkArgument(!Strings.isNullOrEmpty(title));
            this.action = action;
            this.title = title;
            this.icon = icon;
        }
    }

    public static enum Direction {
        AUTO("auto"),
        LEFT_TO_RIGHT("ltr"),
        RIGHT_TO_LEFT("rtl");

        final String value;

        private Direction(String value) {
            this.value = value;
        }
    }
}

