/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.projectmanagement;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.firebase.internal.Nullable;

public class AndroidAppMetadata {
    private final String name;
    private final String appId;
    private final String displayName;
    private final String projectId;
    private final String packageName;

    AndroidAppMetadata(String name, String appId, String displayName, String projectId, String packageName) {
        this.name = Preconditions.checkNotNull(name, "Null name");
        this.appId = Preconditions.checkNotNull(appId, "Null appId");
        this.displayName = displayName;
        this.projectId = Preconditions.checkNotNull(projectId, "Null projectId");
        this.packageName = Preconditions.checkNotNull(packageName, "Null packageName");
    }

    String getName() {
        return this.name;
    }

    public String getAppId() {
        return this.appId;
    }

    @Nullable
    public String getDisplayName() {
        return this.displayName;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String toString() {
        return MoreObjects.toStringHelper("AndroidAppMetadata").add("name", this.name).add("appId", this.appId).add("displayName", this.displayName).add("projectId", this.projectId).add("packageName", this.packageName).toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AndroidAppMetadata) {
            AndroidAppMetadata that = (AndroidAppMetadata)o;
            return Objects.equal(this.name, that.name) && Objects.equal(this.appId, that.appId) && Objects.equal(this.displayName, that.displayName) && Objects.equal(this.projectId, that.projectId) && Objects.equal(this.packageName, that.packageName);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.name, this.appId, this.displayName, this.projectId, this.packageName);
    }
}

