/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.projectmanagement;

import com.google.api.core.ApiFuture;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.firebase.projectmanagement.FirebaseProjectManagementException;
import com.google.firebase.projectmanagement.IosAppMetadata;
import com.google.firebase.projectmanagement.IosAppService;

public class IosApp {
    private final String appId;
    private final IosAppService iosAppService;

    IosApp(String appId, IosAppService iosAppService) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(appId), "app ID cannot be null or empty");
        this.appId = appId;
        this.iosAppService = iosAppService;
    }

    String getAppId() {
        return this.appId;
    }

    public IosAppMetadata getMetadata() throws FirebaseProjectManagementException {
        return this.iosAppService.getIosApp(this.appId);
    }

    public ApiFuture<IosAppMetadata> getMetadataAsync() {
        return this.iosAppService.getIosAppAsync(this.appId);
    }

    public void setDisplayName(String newDisplayName) throws FirebaseProjectManagementException {
        this.iosAppService.setIosDisplayName(this.appId, newDisplayName);
    }

    public ApiFuture<Void> setDisplayNameAsync(String newDisplayName) {
        return this.iosAppService.setIosDisplayNameAsync(this.appId, newDisplayName);
    }

    public String getConfig() throws FirebaseProjectManagementException {
        return this.iosAppService.getIosConfig(this.appId);
    }

    public ApiFuture<String> getConfigAsync() {
        return this.iosAppService.getIosConfigAsync(this.appId);
    }

    public String toString() {
        return String.format("iOS App %s", this.getAppId());
    }
}

