/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig;

import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponseInterceptor;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.JsonFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseException;
import com.google.firebase.ImplFirebaseTrampolines;
import com.google.firebase.IncomingHttpResponse;
import com.google.firebase.internal.AbstractPlatformErrorHandler;
import com.google.firebase.internal.ApiClientUtils;
import com.google.firebase.internal.ErrorHandlingHttpClient;
import com.google.firebase.internal.HttpRequestInfo;
import com.google.firebase.internal.NonNull;
import com.google.firebase.internal.SdkUtils;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigClient;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigException;
import com.google.firebase.remoteconfig.ListVersionsOptions;
import com.google.firebase.remoteconfig.RemoteConfigUtil;
import com.google.firebase.remoteconfig.Template;
import com.google.firebase.remoteconfig.internal.RemoteConfigServiceErrorResponse;
import com.google.firebase.remoteconfig.internal.TemplateResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;

final class FirebaseRemoteConfigClientImpl
implements FirebaseRemoteConfigClient {
    private static final String REMOTE_CONFIG_URL = "https://firebaseremoteconfig.googleapis.com/v1/projects/%s/remoteConfig";
    private static final Map<String, String> COMMON_HEADERS = ImmutableMap.of("X-Firebase-Client", "fire-admin-java/" + SdkUtils.getVersion(), "Accept-Encoding", "gzip");
    private final String remoteConfigUrl;
    private final HttpRequestFactory requestFactory;
    private final JsonFactory jsonFactory;
    private final ErrorHandlingHttpClient<FirebaseRemoteConfigException> httpClient;

    private FirebaseRemoteConfigClientImpl(Builder builder) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(builder.projectId));
        this.remoteConfigUrl = String.format(REMOTE_CONFIG_URL, builder.projectId);
        this.requestFactory = Preconditions.checkNotNull(builder.requestFactory);
        this.jsonFactory = Preconditions.checkNotNull(builder.jsonFactory);
        HttpResponseInterceptor responseInterceptor = builder.responseInterceptor;
        RemoteConfigErrorHandler errorHandler = new RemoteConfigErrorHandler(this.jsonFactory);
        this.httpClient = new ErrorHandlingHttpClient<FirebaseRemoteConfigException>(this.requestFactory, this.jsonFactory, errorHandler).setInterceptor(responseInterceptor);
    }

    @VisibleForTesting
    String getRemoteConfigUrl() {
        return this.remoteConfigUrl;
    }

    @VisibleForTesting
    HttpRequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    @VisibleForTesting
    JsonFactory getJsonFactory() {
        return this.jsonFactory;
    }

    @Override
    public Template getTemplate() throws FirebaseRemoteConfigException {
        HttpRequestInfo request = HttpRequestInfo.buildGetRequest(this.remoteConfigUrl).addAllHeaders(COMMON_HEADERS);
        IncomingHttpResponse response = this.httpClient.send(request);
        TemplateResponse templateResponse = this.httpClient.parse(response, TemplateResponse.class);
        Template template = new Template(templateResponse);
        return template.setETag(this.getETag(response));
    }

    @Override
    public Template getTemplateAtVersion(@NonNull String versionNumber) throws FirebaseRemoteConfigException {
        Preconditions.checkArgument(RemoteConfigUtil.isValidVersionNumber(versionNumber), "Version number must be a non-empty string in int64 format.");
        HttpRequestInfo request = HttpRequestInfo.buildGetRequest(this.remoteConfigUrl).addAllHeaders(COMMON_HEADERS).addParameter("versionNumber", versionNumber);
        IncomingHttpResponse response = this.httpClient.send(request);
        TemplateResponse templateResponse = this.httpClient.parse(response, TemplateResponse.class);
        Template template = new Template(templateResponse);
        return template.setETag(this.getETag(response));
    }

    @Override
    public Template publishTemplate(@NonNull Template template, boolean validateOnly, boolean forcePublish) throws FirebaseRemoteConfigException {
        Preconditions.checkArgument(template != null, "Template must not be null.");
        HttpRequestInfo request = HttpRequestInfo.buildRequest("PUT", this.remoteConfigUrl, new JsonHttpContent(this.jsonFactory, template.toTemplateResponse(false))).addAllHeaders(COMMON_HEADERS).addHeader("If-Match", forcePublish ? "*" : template.getETag());
        if (validateOnly) {
            request.addParameter("validateOnly", true);
        }
        IncomingHttpResponse response = this.httpClient.send(request);
        TemplateResponse templateResponse = this.httpClient.parse(response, TemplateResponse.class);
        Template publishedTemplate = new Template(templateResponse);
        if (validateOnly) {
            return publishedTemplate.setETag(template.getETag());
        }
        return publishedTemplate.setETag(this.getETag(response));
    }

    @Override
    public Template rollback(@NonNull String versionNumber) throws FirebaseRemoteConfigException {
        Preconditions.checkArgument(RemoteConfigUtil.isValidVersionNumber(versionNumber), "Version number must be a non-empty string in int64 format.");
        ImmutableMap<String, String> content = ImmutableMap.of("versionNumber", versionNumber);
        HttpRequestInfo request = HttpRequestInfo.buildJsonPostRequest(this.remoteConfigUrl + ":rollback", content).addAllHeaders(COMMON_HEADERS);
        IncomingHttpResponse response = this.httpClient.send(request);
        TemplateResponse templateResponse = this.httpClient.parse(response, TemplateResponse.class);
        Template template = new Template(templateResponse);
        return template.setETag(this.getETag(response));
    }

    @Override
    public TemplateResponse.ListVersionsResponse listVersions(ListVersionsOptions options) throws FirebaseRemoteConfigException {
        HttpRequestInfo request = HttpRequestInfo.buildGetRequest(this.remoteConfigUrl + ":listVersions").addAllHeaders(COMMON_HEADERS);
        if (options != null) {
            request.addAllParameters(options.wrapForTransport());
        }
        return this.httpClient.sendAndParse(request, TemplateResponse.ListVersionsResponse.class);
    }

    private String getETag(IncomingHttpResponse response) {
        List etagList = (List)response.getHeaders().get("etag");
        Preconditions.checkState(etagList != null && !etagList.isEmpty(), "ETag header is not available in the server response.");
        String etag = (String)etagList.get(0);
        Preconditions.checkState(!Strings.isNullOrEmpty(etag), "ETag header is not available in the server response.");
        return etag;
    }

    static FirebaseRemoteConfigClientImpl fromApp(FirebaseApp app) {
        String projectId = ImplFirebaseTrampolines.getProjectId(app);
        Preconditions.checkArgument(!Strings.isNullOrEmpty(projectId), "Project ID is required to access Remote Config service. Use a service account credential or set the project ID explicitly via FirebaseOptions. Alternatively you can also set the project ID via the GOOGLE_CLOUD_PROJECT environment variable.");
        return FirebaseRemoteConfigClientImpl.builder().setProjectId(projectId).setRequestFactory(ApiClientUtils.newAuthorizedRequestFactory(app)).setJsonFactory(app.getOptions().getJsonFactory()).build();
    }

    static Builder builder() {
        return new Builder();
    }

    private static class RemoteConfigErrorHandler
    extends AbstractPlatformErrorHandler<FirebaseRemoteConfigException> {
        private RemoteConfigErrorHandler(JsonFactory jsonFactory) {
            super(jsonFactory);
        }

        @Override
        protected FirebaseRemoteConfigException createException(FirebaseException base) {
            String response = this.getResponse(base);
            RemoteConfigServiceErrorResponse parsed = this.safeParse(response);
            return FirebaseRemoteConfigException.withRemoteConfigErrorCode(base, parsed.getRemoteConfigErrorCode());
        }

        private String getResponse(FirebaseException base) {
            if (base.getHttpResponse() == null) {
                return null;
            }
            return base.getHttpResponse().getContent();
        }

        private RemoteConfigServiceErrorResponse safeParse(String response) {
            if (!Strings.isNullOrEmpty(response)) {
                try {
                    return this.jsonFactory.createJsonParser(response).parseAndClose(RemoteConfigServiceErrorResponse.class);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return new RemoteConfigServiceErrorResponse();
        }
    }

    static final class Builder {
        private String projectId;
        private HttpRequestFactory requestFactory;
        private JsonFactory jsonFactory;
        private HttpResponseInterceptor responseInterceptor;

        private Builder() {
        }

        Builder setProjectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        Builder setRequestFactory(HttpRequestFactory requestFactory) {
            this.requestFactory = requestFactory;
            return this;
        }

        Builder setJsonFactory(JsonFactory jsonFactory) {
            this.jsonFactory = jsonFactory;
            return this;
        }

        Builder setResponseInterceptor(HttpResponseInterceptor responseInterceptor) {
            this.responseInterceptor = responseInterceptor;
            return this;
        }

        FirebaseRemoteConfigClientImpl build() {
            return new FirebaseRemoteConfigClientImpl(this);
        }
    }
}

