/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig;

import com.google.common.base.Preconditions;
import com.google.firebase.internal.NonNull;
import com.google.firebase.internal.Nullable;
import com.google.firebase.remoteconfig.Parameter;
import com.google.firebase.remoteconfig.internal.TemplateResponse;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class ParameterGroup {
    private String description;
    private Map<String, Parameter> parameters;

    public ParameterGroup() {
        this.parameters = new HashMap<String, Parameter>();
    }

    ParameterGroup(@NonNull TemplateResponse.ParameterGroupResponse parameterGroupResponse) {
        Preconditions.checkNotNull(parameterGroupResponse);
        this.parameters = new HashMap<String, Parameter>();
        if (parameterGroupResponse.getParameters() != null) {
            for (Map.Entry<String, TemplateResponse.ParameterResponse> entry : parameterGroupResponse.getParameters().entrySet()) {
                this.parameters.put(entry.getKey(), new Parameter(entry.getValue()));
            }
        }
        this.description = parameterGroupResponse.getDescription();
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @NonNull
    public Map<String, Parameter> getParameters() {
        return this.parameters;
    }

    public ParameterGroup setDescription(@Nullable String description) {
        this.description = description;
        return this;
    }

    public ParameterGroup setParameters(@NonNull Map<String, Parameter> parameters) {
        Preconditions.checkNotNull(parameters, "parameters must not be null.");
        this.parameters = parameters;
        return this;
    }

    TemplateResponse.ParameterGroupResponse toParameterGroupResponse() {
        HashMap<String, TemplateResponse.ParameterResponse> parameterResponses = new HashMap<String, TemplateResponse.ParameterResponse>();
        for (Map.Entry<String, Parameter> entry : this.parameters.entrySet()) {
            parameterResponses.put(entry.getKey(), entry.getValue().toParameterResponse());
        }
        return new TemplateResponse.ParameterGroupResponse().setDescription(this.description).setParameters(parameterResponses);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParameterGroup that = (ParameterGroup)o;
        return Objects.equals(this.description, that.description) && Objects.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.parameters);
    }
}

