/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig.internal;

import com.google.api.client.json.GenericJson;
import com.google.api.client.util.Key;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.firebase.internal.Nullable;
import com.google.firebase.remoteconfig.RemoteConfigErrorCode;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class RemoteConfigServiceErrorResponse
extends GenericJson {
    private static final Map<String, RemoteConfigErrorCode> RC_ERROR_CODES = ImmutableMap.builder().put("INTERNAL", RemoteConfigErrorCode.INTERNAL).put("INVALID_ARGUMENT", RemoteConfigErrorCode.INVALID_ARGUMENT).put("FAILED_PRECONDITION", RemoteConfigErrorCode.FAILED_PRECONDITION).put("UNAUTHENTICATED", RemoteConfigErrorCode.UNAUTHENTICATED).put("ALREADY_EXISTS", RemoteConfigErrorCode.ALREADY_EXISTS).put("VALIDATION_ERROR", RemoteConfigErrorCode.VALIDATION_ERROR).put("VERSION_MISMATCH", RemoteConfigErrorCode.VERSION_MISMATCH).build();
    private static final Pattern RC_ERROR_CODE_PATTERN = Pattern.compile("^\\[(\\w+)\\]:.*$");
    @Key(value="error")
    private Map<String, Object> error;

    @Nullable
    public RemoteConfigErrorCode getRemoteConfigErrorCode() {
        if (this.error == null) {
            return null;
        }
        String message = (String)this.error.get("message");
        if (Strings.isNullOrEmpty(message)) {
            return null;
        }
        Matcher errorMatcher = RC_ERROR_CODE_PATTERN.matcher(message);
        if (errorMatcher.find()) {
            String errorCode = errorMatcher.group(1);
            return RC_ERROR_CODES.get(errorCode);
        }
        return null;
    }
}

