/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.Managers;

import java.io.File;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import serveressentials.serveressentials.Managers.AFKManager;
import serveressentials.serveressentials.Managers.ConsoleCommandManager;
import serveressentials.serveressentials.Managers.JoinLeaveManager;
import serveressentials.serveressentials.Managers.RulesManager;
import serveressentials.serveressentials.ServerEssentials;
import serveressentials.serveressentials.TPA.TPA;
import serveressentials.serveressentials.auction.AuctionMessagesManager;
import serveressentials.serveressentials.config.RTPConfig;
import serveressentials.serveressentials.economy.EconomyMessagesManager;
import serveressentials.serveressentials.economy.ShopGUIManager;
import serveressentials.serveressentials.kit.KitManager;
import serveressentials.serveressentials.lobby.LobbyManager;
import serveressentials.serveressentials.lobby.LobbyMessages;
import serveressentials.serveressentials.nick.NickManager;
import serveressentials.serveressentials.scoreboard.CustomScoreboardManager;
import serveressentials.serveressentials.staff.BanManager;
import serveressentials.serveressentials.util.DailyMessagesManager;
import serveressentials.serveressentials.util.DailyRewardsManager;
import serveressentials.serveressentials.util.FunMessages;
import serveressentials.serveressentials.util.HomeMessages;
import serveressentials.serveressentials.util.KitMessages;
import serveressentials.serveressentials.util.MessagesManager;
import serveressentials.serveressentials.util.PlayerMessages;
import serveressentials.serveressentials.util.RTPMessages;
import serveressentials.serveressentials.util.ReloadUtils;
import serveressentials.serveressentials.util.ServerMessages;
import serveressentials.serveressentials.util.VaultMessages;
import serveressentials.serveressentials.util.WarpMessages;

public class ReloadManager {
    private static ReloadManager instance;
    private final ServerEssentials plugin;

    public ReloadManager(ServerEssentials plugin) {
        this.plugin = plugin;
        instance = this;
    }

    public static ReloadManager getInstance() {
        if (instance == null) {
            throw new IllegalStateException("ReloadManager has not been initialized yet!");
        }
        return instance;
    }

    public static void reloadAll(CommandSender sender) {
        ReloadManager.getInstance().reloadEverything(sender);
    }

    public void reloadEverything(CommandSender sender) {
        long start = System.currentTimeMillis();
        sender.sendMessage("\u00a7e[ServerEssentials] Reloading all plugin files...");
        File dataFolder = this.plugin.getDataFolder();
        this.plugin.reloadConfig();
        KitManager.reload();
        ShopGUIManager.reload(this.plugin.getDataFolder());
        ShopGUIManager.refreshOpenInventories();
        ShopGUIManager.sectionConfigs.clear();
        BanManager.reload();
        ConsoleCommandManager.reload();
        DailyRewardsManager.reload();
        JoinLeaveManager.reload();
        LobbyManager.reload();
        NickManager.reload();
        RTPConfig.fullReload();
        CustomScoreboardManager.reloadAll();
        RulesManager.reload();
        DailyMessagesManager.fullReload();
        EconomyMessagesManager.reload();
        FunMessages.reloadAll();
        HomeMessages.reloadAll();
        KitMessages.reloadAll();
        LobbyMessages.reload();
        PlayerMessages.reloadAll();
        VaultMessages.fullReload();
        WarpMessages.fullReload();
        ServerMessages.fullReload();
        MessagesManager.fullReload();
        ShopGUIManager.openSection.clear();
        RTPConfig.fullReload();
        RTPMessages.fullReload();
        AuctionMessagesManager.fullReload();
        LobbyManager.reload();
        TPA.fullReload();
        ShopGUIManager.currentPage.clear();
        AFKManager.reload();
        this.plugin.getKitMessages().reload();
        ShopGUIManager.reload(this.plugin.getDataFolder());
        ReloadUtils.reloadAllInDirectory(new File(dataFolder, "config"));
        ReloadUtils.reloadAllInDirectory(new File(dataFolder, "messages"));
        ReloadUtils.reloadAllInDirectory(new File(dataFolder, "shop"));
        ReloadUtils.reloadAllInDirectory(new File(dataFolder, "storage"));
        for (String rootFile : new String[]{"Config.yml", "FJ.yml", "kits.yml", "placeholders.yml"}) {
            File file = new File(dataFolder, rootFile);
            if (!file.exists()) continue;
            ReloadUtils.reloadFile(file);
        }
        long elapsed = System.currentTimeMillis() - start;
        sender.sendMessage("\u00a7a[ServerEssentials] Reload complete in " + elapsed + "ms!");
        Bukkit.getLogger().info("[ServerEssentials] Reloaded all files in " + elapsed + "ms.");
    }
}

