/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.Managers;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class RulesManager {
    private static RulesManager instance;
    private final JavaPlugin plugin;
    private final MiniMessage mini = MiniMessage.miniMessage();
    private File rulesFile;
    private FileConfiguration rulesConfig;

    public RulesManager(JavaPlugin plugin) {
        instance = this;
        this.plugin = plugin;
        this.loadOrCreateRules();
    }

    public static RulesManager getInstance() {
        return instance;
    }

    public static void reload() {
        if (instance != null) {
            instance.reloadRules();
        } else {
            System.out.println("[RulesManager] Tried to reload before initialization!");
        }
    }

    private void loadOrCreateRules() {
        File configFolder = new File(this.plugin.getDataFolder(), "config/rules");
        if (!configFolder.exists()) {
            configFolder.mkdirs();
        }
        this.rulesFile = new File(configFolder, "rules.yml");
        if (!this.rulesFile.exists()) {
            try {
                this.rulesFile.createNewFile();
                this.rulesConfig = YamlConfiguration.loadConfiguration((File)this.rulesFile);
                List<String> defaultRules = Arrays.asList("<green>- Be respectful to others.", "<red>- No griefing or stealing.", "<yellow>- Keep chat appropriate.", "<aqua>- No cheating or using exploits.");
                this.rulesConfig.set("rules", defaultRules);
                this.rulesConfig.save(this.rulesFile);
                this.plugin.getLogger().info("Created new rules.yml with default rules.");
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Failed to create rules.yml: " + e.getMessage());
            }
        } else {
            this.rulesConfig = YamlConfiguration.loadConfiguration((File)this.rulesFile);
        }
    }

    public List<String> getRules() {
        return this.rulesConfig.getStringList("rules");
    }

    public void sendRules(CommandSender sender) {
        sender.sendMessage(this.mini.deserialize("<gold><bold>Server Rules:</bold></gold>"));
        for (String rule : this.getRules()) {
            sender.sendMessage(this.mini.deserialize(rule));
        }
    }

    public void reloadRules() {
        this.rulesConfig = YamlConfiguration.loadConfiguration((File)this.rulesFile);
        this.plugin.getLogger().info("Rules configuration reloaded.");
    }

    public void saveRules() {
        try {
            this.rulesConfig.save(this.rulesFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save rules.yml: " + e.getMessage());
        }
    }
}

