/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.PlaceholderAPI;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import serveressentials.serveressentials.ServerEssentials;

public class TopPlaytimePlaceholder
extends PlaceholderExpansion {
    private final ServerEssentials plugin;

    public TopPlaytimePlaceholder(ServerEssentials plugin) {
        this.plugin = plugin;
    }

    @NotNull
    public String getIdentifier() {
        return "serveressentials";
    }

    @NotNull
    public String getAuthor() {
        return ":_GodlyCow";
    }

    @NotNull
    public String getVersion() {
        return "2.0";
    }

    public boolean persist() {
        return true;
    }

    public String onPlaceholderRequest(OfflinePlayer player, @NotNull String identifier) {
        if (identifier.toLowerCase().startsWith("playtime_top_")) {
            try {
                int rank = Integer.parseInt(identifier.substring("playtime_top_".length()));
                List<Map.Entry<UUID, Long>> top = this.plugin.getPlaytimeManager().getTopPlaytimes(rank);
                if (rank > 0 && rank <= top.size()) {
                    UUID targetUUID = top.get(rank - 1).getKey();
                    long seconds = top.get(rank - 1).getValue();
                    OfflinePlayer topPlayer = Bukkit.getOfflinePlayer((UUID)targetUUID);
                    String name = topPlayer.getName() != null ? topPlayer.getName() : "Unknown";
                    return name + ": " + this.formatTime(seconds);
                }
                return "N/A";
            }
            catch (NumberFormatException e) {
                return "Invalid number";
            }
        }
        return null;
    }

    private String formatTime(long totalSeconds) {
        long days = totalSeconds / 86400L;
        long hours = totalSeconds % 86400L / 3600L;
        long minutes = totalSeconds % 3600L / 60L;
        long seconds = totalSeconds % 60L;
        StringBuilder sb = new StringBuilder();
        if (days > 0L) {
            sb.append(days).append("d ");
        }
        if (hours > 0L) {
            sb.append(hours).append("h ");
        }
        if (minutes > 0L) {
            sb.append(minutes).append("m ");
        }
        sb.append(seconds).append("s");
        return sb.toString().trim();
    }
}

