/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.Player;

import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import serveressentials.serveressentials.util.PlayerMessages;

public class BreakCommand
implements CommandExecutor {
    private final PlayerMessages playerMessages;

    public BreakCommand(PlayerMessages playerMessages) {
        this.playerMessages = playerMessages;
        playerMessages.addDefault("break.no_block", "<red>You are not looking at a breakable block within {distance} blocks.");
        playerMessages.addDefault("break.success", "<green>Broke the block you are looking at.");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        int maxDistance = 5;
        Block targetBlock = player.getTargetBlock(Set.of(Material.AIR, Material.CAVE_AIR, Material.VOID_AIR), maxDistance);
        if (targetBlock == null || targetBlock.getType() == Material.AIR) {
            player.sendMessage(this.playerMessages.get("break.no_block", "{distance}", String.valueOf(maxDistance)));
            return true;
        }
        targetBlock.setType(Material.AIR);
        player.sendMessage(this.playerMessages.get("break.success", new String[0]));
        return true;
    }
}

