/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.Player;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import serveressentials.serveressentials.ServerEssentials;
import serveressentials.serveressentials.util.PlayerMessages;

public class CondenseCommand
implements CommandExecutor {
    private final Map<Material, Material> condenseMap = new HashMap<Material, Material>();
    private final PlayerMessages messages;

    public CondenseCommand(ServerEssentials plugin) {
        this.messages = plugin.getPlayerMessages();
        this.messages.addDefault("condense.only-players", "<red>Only players can use this command!");
        this.messages.addDefault("condense.success", "<green>Your items have been condensed into blocks!");
        this.messages.addDefault("condense.not-enough", "<yellow>You don't have enough items to condense.");
        this.condenseMap.put(Material.IRON_INGOT, Material.IRON_BLOCK);
        this.condenseMap.put(Material.GOLD_INGOT, Material.GOLD_BLOCK);
        this.condenseMap.put(Material.DIAMOND, Material.DIAMOND_BLOCK);
        this.condenseMap.put(Material.EMERALD, Material.EMERALD_BLOCK);
        this.condenseMap.put(Material.REDSTONE, Material.REDSTONE_BLOCK);
        this.condenseMap.put(Material.LAPIS_LAZULI, Material.LAPIS_BLOCK);
        this.condenseMap.put(Material.COAL, Material.COAL_BLOCK);
        this.condenseMap.put(Material.NETHERITE_INGOT, Material.NETHERITE_BLOCK);
        this.condenseMap.put(Material.COPPER_INGOT, Material.COPPER_BLOCK);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.messages.get("condense.only-players", new String[0]));
            return true;
        }
        Player player = (Player)sender;
        boolean condensedSomething = false;
        for (Map.Entry<Material, Material> entry : this.condenseMap.entrySet()) {
            Material ingot = entry.getKey();
            Material block = entry.getValue();
            int totalIngots = 0;
            for (ItemStack item : player.getInventory().getContents()) {
                if (item == null || item.getType() != ingot) continue;
                totalIngots += item.getAmount();
                item.setAmount(0);
            }
            if (totalIngots >= 9) {
                condensedSomething = true;
                int blocks = totalIngots / 9;
                int remainder = totalIngots % 9;
                player.getInventory().addItem(new ItemStack[]{new ItemStack(block, blocks)});
                if (remainder <= 0) continue;
                player.getInventory().addItem(new ItemStack[]{new ItemStack(ingot, remainder)});
                continue;
            }
            if (totalIngots <= 0) continue;
            player.getInventory().addItem(new ItemStack[]{new ItemStack(ingot, totalIngots)});
        }
        if (condensedSomething) {
            player.sendMessage(this.messages.get("condense.success", new String[0]));
        } else {
            player.sendMessage(this.messages.get("condense.not-enough", new String[0]));
        }
        return true;
    }
}

