/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.Player;

import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import serveressentials.serveressentials.util.PlayerMessages;

public class ItemInfoCommand
implements CommandExecutor {
    private final PlayerMessages messages;

    public ItemInfoCommand(PlayerMessages messages) {
        this.messages = messages;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.messages.get("iteminfo.only-players", new String[0]));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("serveressentials.iteminfo")) {
            player.sendMessage(this.messages.get("iteminfo.no-permission", new String[0]));
            return true;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item == null || item.getType() == Material.AIR) {
            player.sendMessage(this.messages.get("iteminfo.no-item", new String[0]));
            return true;
        }
        player.sendMessage(this.messages.get("iteminfo.header", new String[0]));
        player.sendMessage(this.messages.get("iteminfo.type", "<type>", item.getType().toString()));
        player.sendMessage(this.messages.get("iteminfo.amount", "<amount>", String.valueOf(item.getAmount())));
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            if (meta.hasDisplayName()) {
                player.sendMessage(this.messages.get("iteminfo.name", "<name>", meta.getDisplayName()));
            }
            if (meta.hasLore()) {
                player.sendMessage(this.messages.get("iteminfo.lore-header", new String[0]));
                for (String line : meta.getLore()) {
                    player.sendMessage(this.messages.get("iteminfo.lore-line", "<line>", line));
                }
            }
            if (!meta.getEnchants().isEmpty()) {
                player.sendMessage(this.messages.get("iteminfo.enchants-header", new String[0]));
                for (Enchantment enchant : meta.getEnchants().keySet()) {
                    int level = meta.getEnchantLevel(enchant);
                    player.sendMessage(this.messages.get("iteminfo.enchant-line", "<enchant>", enchant.getKey().getKey(), "<level>", String.valueOf(level)));
                }
            }
            if (!meta.getItemFlags().isEmpty()) {
                player.sendMessage(this.messages.get("iteminfo.flags-header", new String[0]));
                for (ItemFlag flag : meta.getItemFlags()) {
                    player.sendMessage(this.messages.get("iteminfo.flag-line", "<flag>", flag.name()));
                }
            }
        }
        return true;
    }
}

