/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.Player;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import serveressentials.serveressentials.ServerEssentials;
import serveressentials.serveressentials.util.PlayerMessages;

public class MailCommand
implements CommandExecutor {
    private final PlayerMessages messages;
    private final File mailFile;
    private FileConfiguration mailConfig;

    public MailCommand(ServerEssentials plugin) {
        this.messages = plugin.getPlayerMessages();
        this.mailFile = new File(plugin.getDataFolder(), "storage/mails.yml");
        if (!this.mailFile.getParentFile().exists()) {
            this.mailFile.getParentFile().mkdirs();
        }
        if (!this.mailFile.exists()) {
            try {
                this.mailFile.createNewFile();
            }
            catch (IOException e) {
                plugin.getLogger().severe("Could not create mails.yml!");
                e.printStackTrace();
            }
        }
        this.mailConfig = YamlConfiguration.loadConfiguration((File)this.mailFile);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.messages.get("Mail.only-players", new String[0]));
            return true;
        }
        Player player = (Player)sender;
        UUID uuid = player.getUniqueId();
        if (args.length == 0 || args[0].equalsIgnoreCase("read")) {
            List inbox = this.mailConfig.getStringList(uuid.toString());
            if (inbox.isEmpty()) {
                player.sendMessage(this.messages.get("Mail.no-mail", new String[0]));
            } else {
                player.sendMessage(this.messages.get("Mail.header", new String[0]));
                for (String msg : inbox) {
                    player.sendMessage(this.messages.get("Mail.message", "{message}", msg));
                }
                this.mailConfig.set(uuid.toString(), new ArrayList());
                this.saveMail();
            }
            return true;
        }
        if (args.length >= 2 && args[0].equalsIgnoreCase("send")) {
            OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[1]);
            UUID targetUUID = target.getUniqueId();
            String message = String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length));
            List inbox = this.mailConfig.getStringList(targetUUID.toString());
            inbox.add(this.messages.get("Mail.from", "{sender}", player.getName(), "{message}", message).toString());
            this.mailConfig.set(targetUUID.toString(), (Object)inbox);
            this.saveMail();
            player.sendMessage(this.messages.get("Mail.sent", "{target}", target.getName()));
            return true;
        }
        player.sendMessage(this.messages.get("Mail.usage", new String[0]));
        return true;
    }

    private void saveMail() {
        try {
            this.mailConfig.save(this.mailFile);
        }
        catch (IOException e) {
            Bukkit.getLogger().severe("Failed to save mails.yml!");
            e.printStackTrace();
        }
    }
}

