/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.Player;

import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import serveressentials.serveressentials.util.PlayerMessages;

public class RecipeCommand
implements CommandExecutor {
    private final PlayerMessages messages;

    public RecipeCommand(PlayerMessages messages) {
        this.messages = messages;
        messages.addDefault("recipe.usage", "<red>Usage: /recipe <recipe>");
        messages.addDefault("recipe.not-found", "<red>Recipe not found!");
        messages.addDefault("recipe.result", "<green>Recipe for: <yellow>{item}");
        messages.addDefault("recipe.shaped-header", "<aqua>Shaped Recipe Ingredients:");
        messages.addDefault("recipe.shapeless-header", "<aqua>Shapeless Recipe Ingredients:");
        messages.addDefault("recipe.ingredient-line", "<yellow>- {char}: {item} x{amount}");
        messages.addDefault("recipe.ingredient-line-shapeless", "<yellow>- {item} x{amount}");
        messages.addDefault("recipe.unknown-type", "<red>Unknown recipe type!");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            sender.sendMessage(this.messages.get("recipe.usage", new String[0]));
            return true;
        }
        NamespacedKey key = NamespacedKey.minecraft((String)args[0]);
        Recipe recipe = Bukkit.getRecipe((NamespacedKey)key);
        if (recipe == null) {
            sender.sendMessage(this.messages.get("recipe.not-found", new String[0]));
            return true;
        }
        ItemStack result = recipe.getResult();
        sender.sendMessage(this.messages.get("recipe.result", "{item}", result.getType().toString()));
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shaped = (ShapedRecipe)recipe;
            sender.sendMessage(this.messages.get("recipe.shaped-header", new String[0]));
            shaped.getIngredientMap().forEach((character, itemStack) -> sender.sendMessage(this.messages.get("recipe.ingredient-line", "{char}", character.toString(), "{item}", itemStack.getType().toString(), "{amount}", String.valueOf(itemStack.getAmount()))));
        } else if (recipe instanceof ShapelessRecipe) {
            ShapelessRecipe shapeless = (ShapelessRecipe)recipe;
            sender.sendMessage(this.messages.get("recipe.shapeless-header", new String[0]));
            for (ItemStack ingredient : shapeless.getIngredientList()) {
                sender.sendMessage(this.messages.get("recipe.ingredient-line-shapeless", "{item}", ingredient.getType().toString(), "{amount}", String.valueOf(ingredient.getAmount())));
            }
        } else {
            sender.sendMessage(this.messages.get("recipe.unknown-type", new String[0]));
        }
        return true;
    }
}

