/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.Player;

import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import serveressentials.serveressentials.ServerEssentials;
import serveressentials.serveressentials.util.PlayerMessages;

public class RenameItemCommand
implements CommandExecutor {
    private final PlayerMessages messages;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();

    public RenameItemCommand(ServerEssentials plugin) {
        this.messages = plugin.getPlayerMessages();
        this.messages.addDefault("rename.usage", "<red>Usage: /rename <name>");
        this.messages.addDefault("rename.no-item", "<red>You're not holding an item.");
        this.messages.addDefault("rename.no-meta", "<red>Could not get item meta.");
        this.messages.addDefault("rename.renamed", "<green>Item renamed to: <white>{item}");
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.messages.get("rename.usage", new String[0]));
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            player.sendMessage(this.messages.get("rename.usage", new String[0]));
            return true;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item == null || item.getType().isAir()) {
            player.sendMessage(this.messages.get("rename.no-item", new String[0]));
            return true;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            player.sendMessage(this.messages.get("rename.no-meta", new String[0]));
            return true;
        }
        String input = String.join((CharSequence)" ", args);
        Object displayName = this.miniMessage.deserialize(input);
        meta.displayName(displayName);
        item.setItemMeta(meta);
        player.sendMessage(this.messages.get("rename.renamed", "{item}", input));
        return true;
    }
}

