/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.Player;

import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import serveressentials.serveressentials.ServerEssentials;
import serveressentials.serveressentials.util.PlayerMessages;

public class RepairCommand
implements CommandExecutor {
    private final PlayerMessages messages;

    public RepairCommand(ServerEssentials plugin) {
        this.messages = plugin.getPlayerMessages();
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        ItemMeta itemMeta;
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.messages.get("Repair.only-players", new String[0]));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("serveressentials.repair")) {
            player.sendMessage(this.messages.get("Repair.no-permission", new String[0]));
            return true;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item == null || item.getType().isAir()) {
            player.sendMessage(this.messages.get("Repair.no-item", new String[0]));
            return true;
        }
        if (item.hasItemMeta() && (itemMeta = item.getItemMeta()) instanceof Damageable) {
            Damageable damageable = (Damageable)itemMeta;
            damageable.setDamage(0);
            item.setItemMeta((ItemMeta)damageable);
            player.sendMessage(this.messages.get("Repair.success", new String[0]));
        } else {
            player.sendMessage(this.messages.get("Repair.cannot-repair", new String[0]));
        }
        return true;
    }
}

