/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.Player;

import java.io.File;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import serveressentials.serveressentials.ServerEssentials;
import serveressentials.serveressentials.util.PlayerMessages;

public class ReportsListCommand
implements CommandExecutor {
    private final ServerEssentials plugin;
    private final PlayerMessages messages;
    private final File file;
    private final FileConfiguration config;

    public ReportsListCommand(ServerEssentials plugin, PlayerMessages messages) {
        this.plugin = plugin;
        this.messages = messages;
        this.file = new File(String.valueOf(plugin.getDataFolder()) + File.separator + "storage", "reports.yml");
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.isOp() && !sender.hasPermission("serveressentials.report.admin")) {
            sender.sendMessage(this.messages.get("report.no-permission", new String[0]));
            return true;
        }
        if (!this.config.contains("reports") || this.config.getConfigurationSection("reports").getKeys(false).isEmpty()) {
            sender.sendMessage(this.messages.get("reports.none", new String[0]));
            return true;
        }
        sender.sendMessage(this.messages.get("reports.header", new String[0]));
        Set keys = this.config.getConfigurationSection("reports").getKeys(false);
        for (String id : keys) {
            String reporterUUID = this.config.getString("reports." + id + ".reporter");
            String targetUUID = this.config.getString("reports." + id + ".target");
            String reason = this.config.getString("reports." + id + ".reason");
            OfflinePlayer reporter = Bukkit.getOfflinePlayer((UUID)UUID.fromString(reporterUUID));
            OfflinePlayer target = Bukkit.getOfflinePlayer((UUID)UUID.fromString(targetUUID));
            Component line = this.messages.get("reports.entry", "{id}", id, "{reporter}", reporter.getName() != null ? reporter.getName() : "Unknown", "{target}", target.getName() != null ? target.getName() : "Unknown", "{reason}", reason);
            sender.sendMessage(line);
        }
        sender.sendMessage(this.messages.get("reports.footer", new String[0]));
        return true;
    }
}

