/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.Player;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import serveressentials.serveressentials.Managers.RulesManager;
import serveressentials.serveressentials.util.PlayerMessages;

public class RulesCommand
implements CommandExecutor,
TabCompleter {
    private final RulesManager rulesManager;
    private final PlayerMessages messages;

    public RulesCommand(RulesManager rulesManager, PlayerMessages messages) {
        this.rulesManager = rulesManager;
        this.messages = messages;
        messages.addDefault("Rules.no-permission", "<red>You don't have permission to perform this action.");
        messages.addDefault("Rules.reloaded", "<green>Rules reloaded.");
        messages.addDefault("Rules.header", "<yellow>---- Server Rules ----");
        messages.addDefault("Rules.rule-line", "<gray>{rule}");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 1 && args[0].equalsIgnoreCase("reload")) {
            if (!sender.hasPermission("serveressentials.rules.reload")) {
                sender.sendMessage(this.messages.get("Rules.no-permission", new String[0]));
                return true;
            }
            this.rulesManager.reloadRules();
            sender.sendMessage(this.messages.get("Rules.reloaded", new String[0]));
            return true;
        }
        if (!sender.hasPermission("serveressentials.rules")) {
            sender.sendMessage(this.messages.get("Rules.no-permission", new String[0]));
            return true;
        }
        sender.sendMessage(this.messages.get("Rules.header", new String[0]));
        for (String rule : this.rulesManager.getRules()) {
            sender.sendMessage(this.messages.get("Rules.rule-line", "{rule}", rule));
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1 && sender.hasPermission("serveressentials.rules.reload")) {
            return Collections.singletonList("reload");
        }
        return new ArrayList<String>();
    }
}

