/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.Player;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import serveressentials.serveressentials.util.PlayerMessages;

public class TeleportWorldCommand
implements CommandExecutor,
TabCompleter {
    private final PlayerMessages messages;

    public TeleportWorldCommand(PlayerMessages messages) {
        this.messages = messages;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Location loc;
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.messages.get("tpp.no-permission", new String[0]));
            return true;
        }
        Player player = (Player)sender;
        if (args.length < 2) {
            sender.sendMessage(this.messages.get("tpp.usage", new String[0]));
            return true;
        }
        String targetName = args[0];
        String worldName = args[1];
        if (!player.hasPermission("serveressentials.tpp." + worldName.toLowerCase())) {
            player.sendMessage(this.messages.get("tpp.no-permission", new String[0]));
            return true;
        }
        Player target = Bukkit.getPlayerExact((String)targetName);
        if (target == null) {
            player.sendMessage(this.messages.get("tpp.player-not-found", "<player>", targetName));
            return true;
        }
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            player.sendMessage(this.messages.get("tpp.world-not-loaded", "<world>", worldName));
            return true;
        }
        if (args.length == 5) {
            try {
                double x = Double.parseDouble(args[2]);
                double y = Double.parseDouble(args[3]);
                double z = Double.parseDouble(args[4]);
                loc = new Location(world, x, y, z);
            }
            catch (NumberFormatException e) {
                player.sendMessage(this.messages.get("tpp.invalid-coords", new String[0]));
                return true;
            }
        } else {
            loc = world.getSpawnLocation();
        }
        target.teleport(loc);
        sender.sendMessage(this.messages.get("tpp.teleported-target", "<player>", target.getName(), "<world>", worldName));
        target.sendMessage(this.messages.get("tpp.teleported-self", "<world>", worldName, "<x>", String.valueOf(loc.getX()), "<y>", String.valueOf(loc.getY()), "<z>", String.valueOf(loc.getZ())));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!(sender instanceof Player)) {
            return Collections.emptyList();
        }
        Player player = (Player)sender;
        if (args.length == 1) {
            String input = args[0].toLowerCase();
            ArrayList<String> onlinePlayers = new ArrayList<String>();
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (!p.getName().toLowerCase().startsWith(input)) continue;
                onlinePlayers.add(p.getName());
            }
            return onlinePlayers;
        }
        if (args.length == 2) {
            String input = args[1].toLowerCase();
            ArrayList<String> allowedWorlds = new ArrayList<String>();
            for (World world : Bukkit.getWorlds()) {
                if (!player.hasPermission("serveressentials.tpp." + world.getName().toLowerCase())) continue;
                allowedWorlds.add(world.getName());
            }
            allowedWorlds.removeIf(w -> !w.toLowerCase().startsWith(input));
            return allowedWorlds;
        }
        return Collections.emptyList();
    }
}

