/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.Player;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.TreeType;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import serveressentials.serveressentials.util.PlayerMessages;

public class TreeCommand
implements CommandExecutor,
TabCompleter {
    private final List<String> treeTypes = Arrays.asList("OAK", "SPRUCE", "BIRCH", "JUNGLE", "ACACIA", "DARK_OAK");
    private final PlayerMessages messages;

    public TreeCommand(PlayerMessages messages) {
        this.messages = messages;
        messages.addDefault("tree.only-players", "<red>Only players can use this command!");
        messages.addDefault("tree.specify-type", "<red>Please specify a tree type.");
        messages.addDefault("tree.invalid-type", "<red>Invalid tree type! Valid types: {types}");
        messages.addDefault("tree.tree-planted", "<green>Tree planted: {type}");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.messages.get("tree.only-players", new String[0]));
            return true;
        }
        Player player = (Player)sender;
        if (args.length < 1) {
            player.sendMessage(this.messages.get("tree.specify-type", new String[0]));
            return true;
        }
        try {
            TreeType type = TreeType.valueOf((String)args[0].toUpperCase());
            player.getWorld().generateTree(player.getLocation(), type);
            player.sendMessage(this.messages.get("tree.tree-planted", "{type}", type.name()));
        }
        catch (IllegalArgumentException e) {
            player.sendMessage(this.messages.get("tree.invalid-type", "{types}", String.join((CharSequence)", ", this.treeTypes)));
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            return this.treeTypes.stream().filter(t2 -> t2.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        return null;
    }
}

