/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.Player;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import serveressentials.serveressentials.util.PlayerMessages;

public class WeatherCommand
implements CommandExecutor,
TabCompleter {
    private final PlayerMessages messages;

    public WeatherCommand(PlayerMessages messages) {
        this.messages = messages;
        messages.addDefault("Weather.Messages.PlayerOnly", "<red>Only players can use this command.");
        messages.addDefault("Weather.Messages.NoPermission", "<red>You do not have permission to use this command.");
        messages.addDefault("Weather.Messages.Usage", "<red>Usage: /weather <clear|rain|thunderstorm>");
        messages.addDefault("Weather.Messages.Clear", "<green>Weather set to clear.");
        messages.addDefault("Weather.Messages.Rain", "<green>Weather set to rain.");
        messages.addDefault("Weather.Messages.Thunderstorm", "<green>Weather set to thunderstorm.");
        messages.addDefault("Weather.Messages.InvalidType", "<red>Invalid weather type. Use: clear, rain, or thunderstorm.");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String type;
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.messages.get("Weather.Messages.PlayerOnly", new String[0]));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("serveressentials.weather")) {
            player.sendMessage(this.messages.get("Weather.Messages.NoPermission", new String[0]));
            return true;
        }
        if (args.length != 1) {
            player.sendMessage(this.messages.get("Weather.Messages.Usage", new String[0]));
            return true;
        }
        World world = player.getWorld();
        switch (type = args[0].toLowerCase()) {
            case "clear": {
                if (!player.hasPermission("serveressentials.weather.clear") && !player.hasPermission("serveressentials.weather.*")) {
                    player.sendMessage(this.messages.get("Weather.Messages.NoPermission", new String[0]));
                    return true;
                }
                world.setStorm(false);
                world.setThundering(false);
                player.sendMessage(this.messages.get("Weather.Messages.Clear", new String[0]));
                break;
            }
            case "rain": {
                if (!player.hasPermission("serveressentials.weather.rain") && !player.hasPermission("serveressentials.weather.*")) {
                    player.sendMessage(this.messages.get("Weather.Messages.NoPermission", new String[0]));
                    return true;
                }
                world.setStorm(true);
                world.setThundering(false);
                player.sendMessage(this.messages.get("Weather.Messages.Rain", new String[0]));
                break;
            }
            case "thunderstorm": {
                if (!player.hasPermission("serveressentials.weather.thunderstorm") && !player.hasPermission("serveressentials.weather.*")) {
                    player.sendMessage(this.messages.get("Weather.Messages.NoPermission", new String[0]));
                    return true;
                }
                world.setStorm(true);
                world.setThundering(true);
                player.sendMessage(this.messages.get("Weather.Messages.Thunderstorm", new String[0]));
                break;
            }
            default: {
                player.sendMessage(this.messages.get("Weather.Messages.InvalidType", new String[0]));
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!(sender instanceof Player)) {
            return null;
        }
        Player player = (Player)sender;
        if (args.length == 1) {
            ArrayList<String> options = new ArrayList<String>();
            if (player.hasPermission("serveressentials.weather.clear") || player.hasPermission("serveressentials.weather.*")) {
                options.add("clear");
            }
            if (player.hasPermission("serveressentials.weather.rain") || player.hasPermission("serveressentials.weather.*")) {
                options.add("rain");
            }
            if (player.hasPermission("serveressentials.weather.thunderstorm") || player.hasPermission("serveressentials.weather.*")) {
                options.add("thunderstorm");
            }
            String current = args[0].toLowerCase();
            ArrayList<String> filtered = new ArrayList<String>();
            for (String option : options) {
                if (!option.startsWith(current)) continue;
                filtered.add(option);
            }
            return filtered;
        }
        return null;
    }
}

