/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.economy;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import serveressentials.serveressentials.economy.EconomyMessagesManager;

public class EcoCommand
implements CommandExecutor,
TabCompleter {
    private final Economy economy;
    private final MiniMessage mm = MiniMessage.miniMessage();

    public EcoCommand(Economy economy) {
        this.economy = economy;
    }

    private OfflinePlayer getTargetPlayer(String name) {
        Player online = Bukkit.getPlayer((String)name);
        return online != null ? online : Bukkit.getOfflinePlayerIfCached((String)name);
    }

    private Component getMessage(String key, Map<String, String> placeholders) {
        return EconomyMessagesManager.getMessage(key, placeholders);
    }

    private Component getMessage(String key) {
        return EconomyMessagesManager.getMessage(key);
    }

    private String getPrefix() {
        return EconomyMessagesManager.getMessage("prefix").toString();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String sub;
        if (args.length < 2) {
            sender.sendMessage(this.getMessage("usage", Map.of("%prefix%", this.getPrefix())));
            return true;
        }
        OfflinePlayer target = this.getTargetPlayer(args[1]);
        if (target == null) {
            sender.sendMessage(this.getMessage("player-not-found", Map.of("%prefix%", this.getPrefix())));
            return true;
        }
        switch (sub = args[0].toLowerCase()) {
            case "give": {
                if (args.length < 3) {
                    return this.sendError(sender, "give-usage");
                }
                double amount = this.parseAmount(args[2], sender, "invalid-amount");
                if (amount < 0.0) {
                    return true;
                }
                this.economy.depositPlayer(target, amount);
                sender.sendMessage(this.getMessage("give-success", Map.of("%player%", target.getName(), "%amount%", String.valueOf(amount))));
                break;
            }
            case "take": {
                if (args.length < 3) {
                    return this.sendError(sender, "take-usage");
                }
                double amount = this.parseAmount(args[2], sender, "invalid-amount");
                if (amount < 0.0) {
                    return true;
                }
                this.economy.withdrawPlayer(target, amount);
                sender.sendMessage(this.getMessage("take-success", Map.of("%player%", target.getName(), "%amount%", String.valueOf(amount))));
                break;
            }
            case "reset": {
                double bal = this.economy.getBalance(target);
                this.economy.withdrawPlayer(target, bal);
                sender.sendMessage(this.getMessage("reset-success", Map.of("%player%", target.getName())));
                break;
            }
            default: {
                this.sendError(sender, "unknown-subcommand");
            }
        }
        return true;
    }

    private boolean sendError(CommandSender sender, String path) {
        sender.sendMessage(this.getMessage(path, Map.of("%prefix%", this.getPrefix())));
        return true;
    }

    private double parseAmount(String input, CommandSender sender, String errorPath) {
        try {
            return Double.parseDouble(input);
        }
        catch (NumberFormatException e) {
            sender.sendMessage(this.getMessage(errorPath, Map.of("%prefix%", this.getPrefix())));
            return -1.0;
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions;
        block3: {
            block2: {
                completions = new ArrayList<String>();
                if (args.length != 1) break block2;
                for (String s2 : List.of("give", "take", "reset")) {
                    if (!s2.startsWith(args[0].toLowerCase())) continue;
                    completions.add(s2);
                }
                break block3;
            }
            if (args.length != 2) break block3;
            String input = args[1].toLowerCase();
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (!p.getName().toLowerCase().startsWith(input)) continue;
                completions.add(p.getName());
            }
        }
        return completions;
    }
}

