/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.economy;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import serveressentials.serveressentials.economy.MainShopConfig;
import serveressentials.serveressentials.economy.ShopConfigLoader;
import serveressentials.serveressentials.economy.ShopSectionConfig;

public class ShopGUIManager {
    private static final MiniMessage mini = MiniMessage.miniMessage();
    private static final Pattern HEX_PATTERN = Pattern.compile("#[a-fA-F0-9]{6}");
    private static Economy economy;
    private static FileConfiguration messages;
    private static MainShopConfig mainConfig;
    public static final Map<String, ShopSectionConfig> sectionConfigs;
    public static final Map<UUID, String> openSection;
    public static final Map<UUID, Integer> currentPage;

    public static void init(Economy eco, File dataFolder) {
        economy = eco;
        File messagesFile = new File(dataFolder, "messages/shop.yml");
        if (!messagesFile.exists()) {
            messagesFile.getParentFile().mkdirs();
            Bukkit.getPluginManager().getPlugin("ServerEssentials").saveResource("messages/shop.yml", false);
        }
        messages = YamlConfiguration.loadConfiguration((File)messagesFile);
    }

    public static void loadShopConfigs(File folder) {
        File mainFile = new File(folder, "main.yml");
        mainConfig = ShopConfigLoader.loadMainConfig(mainFile);
        sectionConfigs.clear();
        File[] sectionFiles = folder.listFiles(f -> f.getName().endsWith(".yml") && !f.getName().equals("config.yml"));
        if (sectionFiles != null) {
            for (File file : sectionFiles) {
                ShopSectionConfig section = ShopConfigLoader.loadSectionConfig(file);
                sectionConfigs.put(file.getName(), section);
            }
        }
    }

    public static void reload(File dataFolder) {
        File messagesFile = new File(dataFolder, "messages/shop.yml");
        if (!messagesFile.exists()) {
            messagesFile.getParentFile().mkdirs();
            Bukkit.getPluginManager().getPlugin("ServerEssentials").saveResource("messages/shop.yml", false);
        }
        messages = YamlConfiguration.loadConfiguration((File)messagesFile);
        File shopFolder = new File(dataFolder, "shop");
        ShopGUIManager.loadShopConfigs(shopFolder);
        Bukkit.getLogger().info("[ServerEssentials] Shop GUI configs reloaded.");
    }

    public static void refreshOpenInventories() {
        for (UUID uuid : new HashSet<UUID>(openSection.keySet())) {
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player == null || player.getOpenInventory() == null) continue;
            String fileName = openSection.get(uuid);
            int page = currentPage.getOrDefault(uuid, 1);
            if (fileName == null) {
                ShopGUIManager.openMainGUI(player);
                continue;
            }
            ShopGUIManager.openSectionGUI(player, fileName, page);
        }
    }

    public static void openMainGUI(Player player) {
        Inventory inv = Bukkit.createInventory(null, (int)ShopGUIManager.mainConfig.size, (String)ShopGUIManager.color(ShopGUIManager.mainConfig.title));
        ShopGUIManager.mainConfig.layout.forEach((slot, deco) -> inv.setItem(slot.intValue(), ShopGUIManager.createItem(deco.material, deco.name, null)));
        ShopGUIManager.mainConfig.sectionButtons.forEach((slot, button) -> inv.setItem(slot.intValue(), ShopGUIManager.createItem(button.material, button.name, button.lore)));
        ItemStack close = new ItemStack(Material.BARRIER);
        ItemMeta meta = close.getItemMeta();
        meta.setDisplayName(ShopGUIManager.color("#FF0000Close"));
        close.setItemMeta(meta);
        inv.setItem(49, close);
        player.openInventory(inv);
        openSection.remove(player.getUniqueId());
    }

    public static void openSectionGUI(Player player, String fileName, int page) {
        ShopSectionConfig section = sectionConfigs.get(fileName);
        if (section == null) {
            player.sendMessage(ShopGUIManager.msg("errors.no-section", Map.of("file", fileName)));
            return;
        }
        Inventory inv = Bukkit.createInventory(null, (int)section.size, (String)ShopGUIManager.color(section.title));
        section.layout.forEach((slot, item) -> inv.setItem(slot.intValue(), ShopGUIManager.createItem(item.material, item.name, item.lore)));
        section.items.values().stream().filter(item -> item.page == page).forEach(item -> inv.setItem(item.slot, ShopGUIManager.createItem(item.material, item.name, item.lore, item.amount)));
        if (section.playerHeadSlot >= 0) {
            ItemStack skull = new ItemStack(Material.PLAYER_HEAD);
            SkullMeta sm = (SkullMeta)skull.getItemMeta();
            sm.setOwningPlayer((OfflinePlayer)player);
            sm.setDisplayName(ShopGUIManager.color("#1BFF00Your Balance"));
            sm.setLore(List.of(ShopGUIManager.color("#3C9C36Balance: #1BFF00" + String.format("%.2f", economy.getBalance((OfflinePlayer)player)) + " $")));
            skull.setItemMeta((ItemMeta)sm);
            inv.setItem(section.playerHeadSlot, skull);
        }
        if (section.closeButtonSlot >= 0) {
            ItemStack barrier = new ItemStack(Material.BARRIER);
            ItemMeta metaClose = barrier.getItemMeta();
            metaClose.setDisplayName(ShopGUIManager.color("#FF0000Back"));
            barrier.setItemMeta(metaClose);
            inv.setItem(section.closeButtonSlot, barrier);
        }
        if (page > 1) {
            inv.setItem(45, ShopGUIManager.createItem(Material.ARROW, ShopGUIManager.color("#AAAAAAPrevious Page"), null));
        }
        if (page < section.pages) {
            inv.setItem(53, ShopGUIManager.createItem(Material.ARROW, ShopGUIManager.color("#AAAAAANext Page"), null));
        }
        player.openInventory(inv);
        openSection.put(player.getUniqueId(), fileName);
        currentPage.put(player.getUniqueId(), page);
    }

    public static void openSectionGUI(Player player, String fileName) {
        ShopGUIManager.openSectionGUI(player, fileName, 1);
    }

    public static void handleClick(InventoryClickEvent e) {
        boolean isSection;
        HumanEntity humanEntity = e.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (e.getClickedInventory() == null || e.getCurrentItem() == null) {
            return;
        }
        UUID uuid = player.getUniqueId();
        String sectionFile = openSection.get(uuid);
        String title = LegacyComponentSerializer.legacySection().serialize(e.getView().title());
        boolean isMainShop = title.equals(ShopGUIManager.color(ShopGUIManager.mainConfig.title));
        boolean bl = isSection = sectionFile != null && sectionConfigs.containsKey(sectionFile);
        if (!isMainShop && !isSection) {
            return;
        }
        if (e.getClickedInventory() != e.getView().getTopInventory()) {
            return;
        }
        e.setCancelled(true);
        if (isMainShop) {
            int slot = e.getSlot();
            if (e.getCurrentItem().getType() == Material.BARRIER) {
                player.closeInventory();
                return;
            }
            MainShopConfig.ShopSectionButton button = ShopGUIManager.mainConfig.sectionButtons.get(slot);
            if (button != null) {
                ShopGUIManager.openSectionGUI(player, button.file);
            }
            return;
        }
        ShopSectionConfig section = sectionConfigs.get(sectionFile);
        int page = currentPage.getOrDefault(uuid, 1);
        int slot = e.getSlot();
        if (slot == 45 && page > 1) {
            ShopGUIManager.openSectionGUI(player, sectionFile, page - 1);
            return;
        }
        if (slot == 53 && page < section.pages) {
            ShopGUIManager.openSectionGUI(player, sectionFile, page + 1);
            return;
        }
        if (e.getCurrentItem().getType() == Material.BARRIER) {
            ShopGUIManager.openMainGUI(player);
            return;
        }
        for (ShopSectionConfig.ShopItem item : section.items.values()) {
            boolean right;
            if (item.page != page || item.slot != slot || !item.clickable) continue;
            boolean left = e.getClick() == ClickType.LEFT;
            boolean bl2 = right = e.getClick() == ClickType.RIGHT;
            if (left && item.buyPrice > 0.0) {
                if (economy.withdrawPlayer((OfflinePlayer)player, item.buyPrice).transactionSuccess()) {
                    player.getInventory().addItem(new ItemStack[]{new ItemStack(item.material, item.amount)});
                    player.sendMessage(ShopGUIManager.msg("shop.buy", Map.of("item", item.name, "price", String.format("%.2f", item.buyPrice))));
                    ShopGUIManager.openSectionGUI(player, sectionFile, page);
                    break;
                }
                player.sendMessage(ShopGUIManager.msg("errors.cannot-afford", Map.of("item", item.name)));
                break;
            }
            if (!right || !(item.sellPrice > 0.0)) break;
            if (player.getInventory().containsAtLeast(new ItemStack(item.material), item.amount)) {
                ShopGUIManager.removeItems(player, item.material, item.amount);
                economy.depositPlayer((OfflinePlayer)player, item.sellPrice);
                player.sendMessage(ShopGUIManager.msg("shop.sell", Map.of("item", item.name, "price", String.format("%.2f", item.sellPrice))));
                ShopGUIManager.openSectionGUI(player, sectionFile, page);
                break;
            }
            player.sendMessage(ShopGUIManager.msg("errors.no-items", Map.of("item", item.name)));
            break;
        }
    }

    private static void removeItems(Player player, Material material, int amount) {
        int remaining = amount;
        ItemStack[] contents = player.getInventory().getContents();
        for (int i = 0; i < contents.length; ++i) {
            ItemStack stack = contents[i];
            if (stack == null || stack.getType() != material) continue;
            int stackAmount = stack.getAmount();
            if (stackAmount <= remaining) {
                player.getInventory().clear(i);
                remaining -= stackAmount;
            } else {
                stack.setAmount(stackAmount - remaining);
                remaining = 0;
            }
            if (remaining <= 0) break;
        }
        player.updateInventory();
    }

    private static Component msg(String path, Map<String, String> placeholders) {
        String raw = messages.getString(path, path);
        if (placeholders != null) {
            for (Map.Entry<String, String> e : placeholders.entrySet()) {
                String value = e.getValue();
                if (value != null) {
                    value = value.replaceAll("&[0-9a-fA-F]", "");
                }
                raw = raw.replace("%" + e.getKey() + "%", value);
            }
        }
        return mini.deserialize(raw);
    }

    private static ItemStack createItem(Material material, String name, List<String> lore) {
        return ShopGUIManager.createItem(material, name, lore, 1);
    }

    private static ItemStack createItem(Material material, String name, List<String> lore, int amount) {
        ItemStack item = new ItemStack(material, amount);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            if (name != null) {
                meta.setDisplayName(ShopGUIManager.color(name));
            }
            if (lore != null) {
                ArrayList<String> formatted = new ArrayList<String>();
                for (String line : lore) {
                    formatted.add(ShopGUIManager.color(line));
                }
                meta.setLore(formatted);
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    public static String color(String text) {
        if (text == null) {
            return "";
        }
        Matcher matcher = HEX_PATTERN.matcher(text);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String hex = matcher.group().substring(1);
            StringBuilder repl = new StringBuilder("\u00a7x");
            for (char c : hex.toCharArray()) {
                repl.append('\u00a7').append(c);
            }
            matcher.appendReplacement(buffer, repl.toString());
        }
        matcher.appendTail(buffer);
        return buffer.toString().replace("&", "\u00a7");
    }

    static {
        sectionConfigs = new HashMap<String, ShopSectionConfig>();
        openSection = new HashMap<UUID, String>();
        currentPage = new HashMap<UUID, Integer>();
    }
}

