/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.homes;

import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import serveressentials.serveressentials.ServerEssentials;
import serveressentials.serveressentials.homes.Home;
import serveressentials.serveressentials.homes.HomeManager;
import serveressentials.serveressentials.homes.HomesConfirmHolder;
import serveressentials.serveressentials.homes.HomesMainHolder;
import serveressentials.serveressentials.util.HomeMessages;

public class HomesGUI {
    private final ServerEssentials plugin;
    private final HomeManager homeManager;
    private final HomeMessages messages;
    private final Integer[] bedSlots = new Integer[]{10, 12, 14, 16, 28, 30, 32, 34};
    private final Integer[] dyeSlots = new Integer[]{19, 21, 23, 25, 37, 39, 41, 43};

    public HomesGUI(ServerEssentials plugin, HomeManager homeManager, HomeMessages messages) {
        this.plugin = plugin;
        this.homeManager = homeManager;
        this.messages = messages;
    }

    public void openMain(Player p) {
        Inventory inv = Bukkit.createInventory((InventoryHolder)new HomesMainHolder(), (int)54, (Component)this.messages.get("gui.title.main"));
        this.fillBackground(inv);
        UUID uuid = p.getUniqueId();
        int bedCount = this.bedSlots.length;
        int dyeCount = this.dyeSlots.length;
        for (int i = 0; i < Math.max(bedCount, dyeCount); ++i) {
            boolean hasHome;
            int homeIndex;
            int slot;
            if (i < bedCount) {
                slot = this.bedSlots[i];
                homeIndex = i + 1;
                boolean allowed = this.canSetHome(p, homeIndex);
                hasHome = this.homeManager.getHome(uuid, homeIndex).isPresent();
                inv.setItem(slot, this.getBedForState(hasHome, allowed, homeIndex, uuid));
            }
            if (i >= dyeCount) continue;
            slot = this.dyeSlots[i];
            homeIndex = i + 1;
            boolean removeAllowed = p.hasPermission("serveressentials.removehome");
            hasHome = this.homeManager.getHome(uuid, homeIndex).isPresent();
            inv.setItem(slot, this.getDyeForState(hasHome, removeAllowed, homeIndex, uuid));
        }
        p.openInventory(inv);
    }

    public Inventory createConfirmInventory(Player p, int homeIndex, String mode) {
        Inventory inv = Bukkit.createInventory((InventoryHolder)new HomesConfirmHolder(homeIndex, mode), (int)27, (Component)this.messages.get("gui.title.confirm"));
        ItemStack green = new ItemStack(Material.GREEN_STAINED_GLASS_PANE);
        ItemMeta gm = green.getItemMeta();
        gm.displayName(this.messages.get("msg.confirm"));
        green.setItemMeta(gm);
        ItemStack red = new ItemStack(Material.RED_STAINED_GLASS_PANE);
        ItemMeta rm = red.getItemMeta();
        rm.displayName(this.messages.get("msg.cancel"));
        red.setItemMeta(rm);
        inv.setItem(10, green);
        inv.setItem(16, red);
        ItemStack info = new ItemStack(Material.PAPER);
        ItemMeta im = info.getItemMeta();
        ArrayList<Component> lore = new ArrayList<Component>();
        Optional<Home> home = this.homeManager.getHome(p.getUniqueId(), homeIndex);
        home.ifPresent(h2 -> {
            lore.add(this.messages.get("lore.name", "{name}", h2.getName()));
            lore.add(this.messages.get("lore.coords", "{x}", String.valueOf(Math.round(h2.getX())), "{y}", String.valueOf(Math.round(h2.getY())), "{z}", String.valueOf(Math.round(h2.getZ()))));
        });
        if (lore.isEmpty()) {
            lore.add(this.messages.get("lore.empty"));
        }
        im.displayName(this.messages.get("gui.confirm.title", "{home}", String.valueOf(homeIndex), "{mode}", mode));
        im.lore(lore);
        info.setItemMeta(im);
        inv.setItem(13, info);
        for (int i = 0; i < 27; ++i) {
            if (inv.getItem(i) != null) continue;
            ItemStack filler = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
            ItemMeta fm = filler.getItemMeta();
            fm.displayName(this.messages.get("gui.filler"));
            filler.setItemMeta(fm);
            inv.setItem(i, filler);
        }
        return inv;
    }

    public boolean canSetHome(Player p, int homeIndex) {
        if (!p.hasPermission("serveressentials.sethome")) {
            return false;
        }
        if (p.hasPermission("serveressentials.sethome.*")) {
            return true;
        }
        return p.hasPermission("serveressentials.sethome." + homeIndex);
    }

    private void fillBackground(Inventory inv) {
        ItemStack filler = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta m4 = filler.getItemMeta();
        m4.displayName(this.messages.get("gui.filler"));
        filler.setItemMeta(m4);
        for (int slot = 0; slot < inv.getSize(); ++slot) {
            if (inv.getItem(slot) != null) continue;
            inv.setItem(slot, filler);
        }
    }

    private ItemStack getBedForState(boolean hasHome, boolean allowed, int homeIndex, UUID uuid) {
        Material mat;
        ArrayList<Component> lore = new ArrayList<Component>();
        if (!allowed) {
            mat = Material.RED_BED;
            lore.add(this.messages.get("msg.no-permission"));
        } else if (!hasHome) {
            mat = Material.GRAY_BED;
            lore.add(this.messages.get("lore.click.set"));
        } else {
            mat = Material.BLUE_BED;
            this.homeManager.getHome(uuid, homeIndex).ifPresent(h2 -> {
                lore.add(this.messages.get("lore.name", "{name}", h2.getName()));
                lore.add(this.messages.get("lore.coords", "{x}", String.valueOf(Math.round(h2.getX())), "{y}", String.valueOf(Math.round(h2.getY())), "{z}", String.valueOf(Math.round(h2.getZ()))));
                lore.add(this.messages.get("lore.click.teleport"));
                lore.add(this.messages.get("lore.click.manage"));
            });
        }
        ItemStack item = new ItemStack(mat);
        ItemMeta meta = item.getItemMeta();
        meta.displayName(this.messages.get("gui.home-title", "{home}", String.valueOf(homeIndex)));
        meta.lore(lore);
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack getDyeForState(boolean hasHome, boolean allowed, int homeIndex, UUID uuid) {
        Material mat;
        ArrayList<Component> lore = new ArrayList<Component>();
        if (!allowed) {
            mat = Material.RED_DYE;
            lore.add(this.messages.get("msg.no-permission"));
        } else if (!hasHome) {
            mat = Material.GRAY_DYE;
            lore.add(this.messages.get("lore.empty"));
            lore.add(this.messages.get("lore.click.set"));
        } else {
            mat = Material.LIME_DYE;
            this.homeManager.getHome(uuid, homeIndex).ifPresent(h2 -> {
                lore.add(this.messages.get("lore.name", "{name}", h2.getName()));
                lore.add(this.messages.get("lore.coords", "{x}", String.valueOf(Math.round(h2.getX())), "{y}", String.valueOf(Math.round(h2.getY())), "{z}", String.valueOf(Math.round(h2.getZ()))));
                lore.add(this.messages.get("lore.click.remove"));
            });
        }
        ItemStack item = new ItemStack(mat);
        ItemMeta meta = item.getItemMeta();
        meta.displayName(this.messages.get("gui.home-dye-title", "{home}", String.valueOf(homeIndex)));
        meta.lore(lore);
        item.setItemMeta(meta);
        return item;
    }

    public Integer[] getBedSlots() {
        return this.bedSlots;
    }

    public Integer[] getDyeSlots() {
        return this.dyeSlots;
    }
}

