/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.interaction_blocks;

import java.io.File;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import serveressentials.serveressentials.ServerEssentials;

public class BlastFurnaceCommand
implements CommandExecutor,
Listener {
    private final ServerEssentials plugin;
    private YamlConfiguration messages;
    private File messageFile;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();
    private final PlainTextComponentSerializer plainSerializer = PlainTextComponentSerializer.plainText();

    public BlastFurnaceCommand(ServerEssentials plugin) {
        this.plugin = plugin;
        this.loadMessages();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    private void loadMessages() {
        this.messageFile = new File(this.plugin.getDataFolder(), "messages/interaction_blocks.yml");
        if (!this.messageFile.exists()) {
            this.plugin.saveResource("messages/interaction_blocks.yml", false);
        }
        this.messages = YamlConfiguration.loadConfiguration((File)this.messageFile);
    }

    private Component getMessage(String path) {
        String msg = this.messages.getString(path, "<red>Missing message: " + path);
        return this.miniMessage.deserialize(msg);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plainSerializer.serialize(this.getMessage("only-players")));
            return true;
        }
        Player player = (Player)sender;
        String guiName = this.plainSerializer.serialize(this.getMessage("gui-title-blast-furnace"));
        Inventory blastFurnace = Bukkit.createInventory((InventoryHolder)player, (int)27, (String)guiName);
        ItemStack barrier = new ItemStack(Material.BARRIER);
        ItemMeta meta = barrier.getItemMeta();
        if (meta != null) {
            meta.displayName(this.miniMessage.deserialize("<red><bold>ERROR"));
            meta.lore(List.of(this.getMessage("not-implemented-lore")));
            barrier.setItemMeta(meta);
        }
        blastFurnace.setItem(13, barrier);
        player.openInventory(blastFurnace);
        player.playSound(player.getLocation(), Sound.BLOCK_BLASTFURNACE_FIRE_CRACKLE, 1.0f, 1.0f);
        player.sendMessage(this.getMessage("opened-blast-furnace"));
        return true;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        ItemMeta meta;
        ItemStack item = event.getCurrentItem();
        if (item == null) {
            return;
        }
        if (item.getType() == Material.BARRIER && (meta = item.getItemMeta()) != null && meta.hasDisplayName() && meta.displayName().equals(this.miniMessage.deserialize("<red><bold>ERROR"))) {
            event.setCancelled(true);
            HumanEntity humanEntity = event.getWhoClicked();
            if (humanEntity instanceof Player) {
                Player player = (Player)humanEntity;
                player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                player.sendMessage(this.getMessage("clicked-barrier"));
            }
        }
    }
}

