/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.interaction_blocks;

import java.io.File;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import serveressentials.serveressentials.ServerEssentials;

public class GrindstoneCommand
implements CommandExecutor {
    private final ServerEssentials plugin;
    private YamlConfiguration messages;
    private File messageFile;
    private final MiniMessage miniMessage;

    public GrindstoneCommand(ServerEssentials plugin) {
        this.plugin = plugin;
        this.miniMessage = MiniMessage.miniMessage();
        this.loadMessages();
    }

    private void loadMessages() {
        this.messageFile = new File(this.plugin.getDataFolder(), "messages/interaction_blocks.yml");
        if (!this.messageFile.exists()) {
            this.plugin.saveResource("messages/interaction_blocks.yml", false);
        }
        this.messages = YamlConfiguration.loadConfiguration((File)this.messageFile);
    }

    private Component getMessage(String path) {
        String msg = this.messages.getString(path, "<red>Missing message: " + path + "</red>");
        return this.miniMessage.deserialize(msg);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.miniMessage.deserialize("<red>Only players can use this command.</red>"));
            return true;
        }
        Player player = (Player)sender;
        player.openGrindstone(null, true);
        this.plugin.adventure().player(player).sendMessage(this.getMessage("opened-grindstone"));
        return true;
    }
}

