/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.listeners;

import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SpawnerPlaceListener
implements Listener {
    private final JavaPlugin plugin;

    public SpawnerPlaceListener(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onSpawnerPlace(BlockPlaceEvent event) {
        ItemStack item = event.getItemInHand();
        if (item.getType() == Material.SPAWNER && item.hasItemMeta()) {
            ItemMeta meta = item.getItemMeta();
            NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "mobType");
            if (meta.getPersistentDataContainer().has(key, PersistentDataType.STRING)) {
                String mobTypeName = (String)meta.getPersistentDataContainer().get(key, PersistentDataType.STRING);
                EntityType mobType = EntityType.valueOf((String)mobTypeName);
                Block block = event.getBlockPlaced();
                BlockState blockState = block.getState();
                if (blockState instanceof CreatureSpawner) {
                    CreatureSpawner spawner = (CreatureSpawner)blockState;
                    spawner.setSpawnedType(mobType);
                    spawner.update();
                }
            }
        }
    }
}

