/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.scoreboard;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import serveressentials.serveressentials.scoreboard.ScoreboardStorage;

public class ScoreboardConfig {
    private final File file;
    private final JavaPlugin plugin;
    private YamlConfiguration config;

    public ScoreboardConfig(JavaPlugin plugin) {
        this.plugin = plugin;
        this.file = new File(plugin.getDataFolder(), "config/scoreboard/scoreboard.yml");
        if (!this.file.exists()) {
            plugin.getDataFolder().mkdirs();
            plugin.saveResource("config/scoreboard/scoreboard.yml", false);
        }
        this.reload();
    }

    public void reload() {
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public List<String> getLayouts() {
        if (!this.config.contains("layouts")) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(this.config.getConfigurationSection("layouts").getKeys(false));
    }

    public boolean isWorldEnabled(String world) {
        return this.config.getBoolean("world-settings." + world + ".enabled", true);
    }

    public boolean layoutExists(String layout) {
        return this.config.contains("layouts." + layout);
    }

    public String getTitle(String layout) {
        if (!this.layoutExists(layout)) {
            layout = this.config.getString("global.default-layout", "default");
        }
        return this.config.getString("layouts." + layout + ".title", "<red>Scoreboard");
    }

    public List<String> getLines(String layout) {
        List lines;
        if (!this.layoutExists(layout)) {
            layout = this.config.getString("global.default-layout", "default");
        }
        if ((lines = this.config.getStringList("layouts." + layout + ".lines")) == null || lines.isEmpty()) {
            return List.of("<red>No lines set!");
        }
        return lines;
    }

    public String getLayoutForPlayer(Player player, ScoreboardStorage storage) {
        String playerLayout = storage.getPlayerLayout(player);
        if (playerLayout != null && !playerLayout.isEmpty()) {
            return playerLayout;
        }
        String world = player.getWorld().getName();
        if (this.config.contains("world-settings." + world + ".layout")) {
            return this.config.getString("world-settings." + world + ".layout");
        }
        return this.config.getString("global.default-layout", "default");
    }

    public boolean isEnabledGlobal() {
        return this.config.getBoolean("global.enabled", true);
    }
}

