/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.scoreboard;

import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import serveressentials.serveressentials.scoreboard.CustomScoreboardManager;

public class ScoreboardListener
implements Listener {
    private final CustomScoreboardManager manager;

    public ScoreboardListener(CustomScoreboardManager manager) {
        this.manager = manager;
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        this.manager.getDatabase().load(uuid).thenAccept(data -> {
            boolean enabled = data.enabled();
            String layout = data.layout();
            this.manager.getStorage().setPlayerLayout(player, layout);
            this.manager.getStorage().setCachedState(uuid, enabled);
            this.manager.getPlugin().getServer().getScheduler().runTask((Plugin)this.manager.getPlugin(), () -> {
                if (enabled) {
                    this.manager.getUpdater().update(player);
                } else {
                    this.manager.getUpdater().clear(player);
                }
            });
        });
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        boolean enabled = this.manager.getStorage().isEnabled(player);
        String layout = this.manager.getStorage().getPlayerLayout(player);
        this.manager.getDatabase().save(uuid, enabled, layout);
        this.manager.getStorage().removeCachedState(uuid);
    }

    @EventHandler
    public void onWorldChange(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        this.manager.getUpdater().update(player);
    }
}

