/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.serverEssentials;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.json.JSONArray;
import org.json.JSONObject;
import serveressentials.serveressentials.ServerEssentials;

public class VersionChecker {
    private static final String MODRINTH_PROJECT_ID = "K7HZMVgx";
    private static String latestVersion = "unknown";

    public static void checkLatestVersion(Plugin plugin) {
        HttpClient client = HttpClient.newHttpClient();
        String url = "https://api.modrinth.com/v2/project/K7HZMVgx/version";
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).build();
        ((CompletableFuture)((CompletableFuture)client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(HttpResponse::body)).thenAccept(response -> {
            try {
                JSONArray versions = new JSONArray((String)response);
                if (versions.length() > 0) {
                    JSONObject latest = versions.getJSONObject(0);
                    latestVersion = latest.getString("version_number");
                    String currentVersion = plugin.getDescription().getVersion();
                    if (!currentVersion.equalsIgnoreCase(latestVersion)) {
                        Bukkit.getLogger().info("================================");
                        Bukkit.getLogger().info("  ServerEssentials - Update");
                        Bukkit.getLogger().info("--------------------------------");
                        Bukkit.getLogger().info(" Current: " + currentVersion);
                        Bukkit.getLogger().info(" Latest : " + latestVersion);
                        Bukkit.getLogger().info(" Download: https://modrinth.com/plugin/serveressentials");
                        Bukkit.getLogger().info("================================");
                    } else {
                        Bukkit.getLogger().info("================================");
                        Bukkit.getLogger().info("  ServerEssentials - Version");
                        Bukkit.getLogger().info("--------------------------------");
                        Bukkit.getLogger().info(" You are running the latest version: " + currentVersion);
                        Bukkit.getLogger().info("================================");
                    }
                }
            }
            catch (Exception e) {
                Bukkit.getLogger().warning("================================");
                Bukkit.getLogger().warning(" Failed to parse version data from Modrinth.");
                Bukkit.getLogger().warning("================================");
            }
        })).exceptionally(e -> {
            Bukkit.getLogger().warning("================================");
            Bukkit.getLogger().warning(" Could not fetch latest version from Modrinth.");
            Bukkit.getLogger().warning("================================");
            return null;
        });
    }

    public static void notifyIfOutdated(Player player) {
        String currentVersion = ServerEssentials.getInstance().getDescription().getVersion();
        String latest = VersionChecker.getLatestVersion();
        if (!latest.equals("unknown") && !currentVersion.equals(latest) && (player.hasPermission("serveressentials.version.notify") || player.isOp())) {
            player.sendMessage("\u00a78================================");
            player.sendMessage("\u00a7f \u00a7lServerEssentials - Update");
            player.sendMessage("\u00a78--------------------------------");
            player.sendMessage("\u00a77 Current: \u00a7o\u00a74" + currentVersion);
            player.sendMessage("\u00a77 Latest : \u00a7o\u00a7a" + latest);
            player.sendMessage("\u00a77 Download: \u00a79https://modrinth.com/plugin/serveressentials");
            player.sendMessage("\u00a78================================");
        }
    }

    public static String getCurrentVersion() {
        return ServerEssentials.getInstance().getDescription().getVersion();
    }

    public static String getLatestVersion() {
        return latestVersion;
    }
}

