/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.staff;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import net.kyori.adventure.text.Component;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import serveressentials.serveressentials.ServerEssentials;
import serveressentials.serveressentials.staff.BanManager;
import serveressentials.serveressentials.util.MessagesManager;

public class BanListCommand
implements CommandExecutor {
    private final BanManager banManager;
    private final MessagesManager messages;

    public BanListCommand(ServerEssentials plugin, BanManager banManager) {
        this.banManager = banManager;
        this.messages = new MessagesManager(plugin);
        this.messages.addDefault("banlist.no-permission", "<red>You don't have permission.");
        this.messages.addDefault("banlist.empty", "<yellow>There are no banned players.");
        this.messages.addDefault("banlist.header", "<gold>------[ Banned Players ]------");
        this.messages.addDefault("banlist.format", "<red>%player% <gray>- <white>%reason% <gray>(<aqua>%time%</aqua>)");
        this.messages.addDefault("banlist.footer", "<gold>-----------------------------");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("serveressentials.ban.use")) {
            sender.sendMessage(this.messages.getMessageComponent("banlist.no-permission", new String[0]));
            return true;
        }
        Set<String> bannedUUIDs = this.banManager.getAllBannedUUIDs();
        if (bannedUUIDs.isEmpty()) {
            sender.sendMessage(this.messages.getMessageComponent("banlist.empty", new String[0]));
            return true;
        }
        sender.sendMessage(this.messages.getMessageComponent("banlist.header", new String[0]));
        for (String uuid : bannedUUIDs) {
            String name = this.banManager.getNameFromUUID(uuid);
            String reason = this.banManager.getReason(uuid);
            long until = this.banManager.getUntil(uuid);
            String time = until == -1L ? "Permanent" : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(until));
            Component line = this.messages.getMessageComponent("banlist.format", "%player%", name, "%reason%", reason, "%time%", time);
            sender.sendMessage(line);
        }
        sender.sendMessage(this.messages.getMessageComponent("banlist.footer", new String[0]));
        return true;
    }
}

