/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.staff;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.server.ServerListPingEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import serveressentials.serveressentials.util.MessagesManager;

public class LockdownCommand
implements CommandExecutor,
Listener {
    private final JavaPlugin plugin;
    private final MessagesManager messagesManager;
    private final PlainTextComponentSerializer plain = PlainTextComponentSerializer.plainText();
    private boolean lockdownActive = false;
    private boolean awaitingConfirmation = false;
    private final Set<UUID> frozenPlayers = new HashSet<UUID>();
    private final String originalMotd;

    public LockdownCommand(JavaPlugin plugin, MessagesManager messagesManager, String originalMotd) {
        this.plugin = plugin;
        this.messagesManager = messagesManager;
        this.originalMotd = originalMotd;
        messagesManager.addDefault("Lockdown.no-permission", "<red>You don't have permission to use this command.");
        messagesManager.addDefault("Lockdown.not-active", "<yellow>Lockdown is not active.");
        messagesManager.addDefault("Lockdown.trigger-confirm", "<red>Are you sure you want to trigger LOCKDOWN? Type '/lockdown confirm' to proceed.");
        messagesManager.addDefault("Lockdown.triggered", "<dark_red><bold>!!! LOCKDOWN IS NOW ACTIVE !!!");
        messagesManager.addDefault("Lockdown.lockdown-enabled-op", "<red><bold>\u26a0 LOCKDOWN ENABLED \u26a0");
        messagesManager.addDefault("Lockdown.disabled", "<green>Lockdown has been disabled.");
        messagesManager.addDefault("Lockdown.usage", "<yellow>Usage: /lockdown confirm or /lockdown disable");
        messagesManager.addDefault("Lockdown.kick-message", "<red>LOCKDOWN is active. Come back later.");
        messagesManager.addDefault("Lockdown.motd-lockdown", "<red><bold>\u26a0 LOCKDOWN MODE \u26a0\n<yellow>Server access restricted");
    }

    public boolean isLockdownActive() {
        return this.lockdownActive;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player player;
        if (!(sender instanceof Player) || !(player = (Player)sender).hasPermission("serveressentials.lockdown")) {
            sender.sendMessage(this.plain.serialize(this.messagesManager.get("staff.yml", "Lockdown.no-permission", new String[0])));
            return true;
        }
        if (args.length == 1 && args[0].equalsIgnoreCase("disable")) {
            if (!this.lockdownActive) {
                player.sendMessage(this.plain.serialize(this.messagesManager.get("staff.yml", "Lockdown.not-active", new String[0])));
                return true;
            }
            this.disableLockdown();
            Bukkit.broadcast((Component)this.messagesManager.get("staff.yml", "Lockdown.disabled", new String[0]));
            return true;
        }
        if (!this.awaitingConfirmation) {
            this.awaitingConfirmation = true;
            player.sendMessage(this.plain.serialize(this.messagesManager.get("staff.yml", "Lockdown.trigger-confirm", new String[0])));
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                this.awaitingConfirmation = false;
            }, 200L);
            return true;
        }
        if (args.length == 1 && args[0].equalsIgnoreCase("confirm")) {
            this.awaitingConfirmation = false;
            this.triggerLockdown();
            return true;
        }
        player.sendMessage(this.plain.serialize(this.messagesManager.get("staff.yml", "Lockdown.usage", new String[0])));
        return true;
    }

    private void triggerLockdown() {
        this.lockdownActive = true;
        Bukkit.setMotd((String)this.plain.serialize(this.messagesManager.get("staff.yml", "Lockdown.motd-lockdown", new String[0])));
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (!p.isOp()) {
                this.frozenPlayers.add(p.getUniqueId());
                p.sendTitle("\u00a74LOCKDOWN", "\u00a7cYou are being removed...", 10, 60, 10);
                p.playSound(p.getLocation(), Sound.ENTITY_ENDER_DRAGON_GROWL, 1.0f, 0.5f);
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                    if (p.isOnline()) {
                        p.kick(this.messagesManager.get("staff.yml", "Lockdown.kick-message", new String[0]));
                    }
                }, 60L);
                continue;
            }
            p.sendMessage(this.messagesManager.get("staff.yml", "Lockdown.lockdown-enabled-op", new String[0]));
        }
        Bukkit.broadcast((Component)this.messagesManager.get("staff.yml", "Lockdown.triggered", new String[0]));
    }

    private void disableLockdown() {
        this.lockdownActive = false;
        this.frozenPlayers.clear();
        Bukkit.setMotd((String)this.originalMotd);
    }

    @EventHandler
    public void onPlayerLogin(PlayerLoginEvent event) {
        if (this.lockdownActive && !event.getPlayer().isOp()) {
            event.disallow(PlayerLoginEvent.Result.KICK_OTHER, this.plain.serialize(this.messagesManager.get("staff.yml", "Lockdown.kick-message", new String[0])));
        }
    }

    @EventHandler
    public void onPing(ServerListPingEvent event) {
        if (this.lockdownActive) {
            event.setMotd(this.plain.serialize(this.messagesManager.get("staff.yml", "Lockdown.motd-lockdown", new String[0])));
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        if (this.lockdownActive && this.frozenPlayers.contains(event.getPlayer().getUniqueId()) && !event.getFrom().toVector().equals((Object)event.getTo().toVector())) {
            event.setTo(event.getFrom());
        }
    }

    @EventHandler
    public void onCommand(PlayerCommandPreprocessEvent event) {
        if (this.lockdownActive && this.frozenPlayers.contains(event.getPlayer().getUniqueId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent event) {
        if (this.lockdownActive && this.frozenPlayers.contains(event.getPlayer().getUniqueId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onDamage(EntityDamageEvent event) {
        Player p;
        Entity entity = event.getEntity();
        if (entity instanceof Player && this.frozenPlayers.contains((p = (Player)entity).getUniqueId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onHunger(FoodLevelChangeEvent event) {
        Player p;
        HumanEntity humanEntity = event.getEntity();
        if (humanEntity instanceof Player && this.frozenPlayers.contains((p = (Player)humanEntity).getUniqueId())) {
            event.setCancelled(true);
        }
    }
}

