/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.staff;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import serveressentials.serveressentials.ServerEssentials;
import serveressentials.serveressentials.util.MessagesManager;

public class PlayerInfoCommand
implements CommandExecutor {
    private final MessagesManager messages;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();

    public PlayerInfoCommand(ServerEssentials plugin) {
        this.messages = new MessagesManager(plugin);
        this.messages.addDefault("playerinfo.usage", "<red>Usage: /playerinfo <player>");
        this.messages.addDefault("playerinfo.not-found", "<red>Player not found.");
        this.messages.addDefault("playerinfo.header", "<gold>----- Player Info -----");
        this.messages.addDefault("playerinfo.name", "<yellow>Name: %player%");
        this.messages.addDefault("playerinfo.uuid", "<yellow>UUID: %uuid%");
        this.messages.addDefault("playerinfo.health", "<yellow>Health: %health%/%maxhealth%");
        this.messages.addDefault("playerinfo.food", "<yellow>Food: %food%");
        this.messages.addDefault("playerinfo.location", "<yellow>Location: %location%");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            this.sendMessage(sender, "playerinfo.usage");
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null) {
            this.sendMessage(sender, "playerinfo.not-found");
            return true;
        }
        this.sendMessage(sender, "playerinfo.header");
        this.sendMessage(sender, "playerinfo.name", target);
        this.sendMessage(sender, "playerinfo.uuid", target);
        this.sendMessage(sender, "playerinfo.health", target);
        this.sendMessage(sender, "playerinfo.food", target);
        this.sendMessage(sender, "playerinfo.location", target);
        return true;
    }

    private void sendMessage(CommandSender sender, String path) {
        Component message = this.messages.getMessageComponent(path, new String[0]);
        if (sender instanceof Player) {
            Player p = (Player)sender;
            p.sendMessage(message);
        } else {
            sender.sendMessage(LegacyComponentSerializer.legacyAmpersand().serialize(message));
        }
    }

    private void sendMessage(CommandSender sender, String path, Player target) {
        Component message = this.messages.getMessageComponent(path, new String[0]).replaceText(builder -> builder.matchLiteral("%player%").replacement(target.getName())).replaceText(builder -> builder.matchLiteral("%uuid%").replacement(target.getUniqueId().toString())).replaceText(builder -> builder.matchLiteral("%health%").replacement(String.valueOf(target.getHealth()))).replaceText(builder -> builder.matchLiteral("%maxhealth%").replacement(String.valueOf(target.getMaxHealth()))).replaceText(builder -> builder.matchLiteral("%food%").replacement(String.valueOf(target.getFoodLevel()))).replaceText(builder -> builder.matchLiteral("%location%").replacement(target.getLocation().toVector().toString()));
        if (sender instanceof Player) {
            Player p = (Player)sender;
            p.sendMessage(message);
        } else {
            sender.sendMessage(LegacyComponentSerializer.legacyAmpersand().serialize(message));
        }
    }
}

