/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.staff;

import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import serveressentials.serveressentials.ServerEssentials;
import serveressentials.serveressentials.util.MessagesManager;

public class TPOfflineCommand
implements CommandExecutor {
    private final ServerEssentials plugin;
    private final MessagesManager messages;

    public TPOfflineCommand(ServerEssentials plugin) {
        this.plugin = plugin;
        this.messages = new MessagesManager(plugin);
        this.messages.addDefault("tpoffline.usage", "<red>Usage: /tpoffline <player>");
        this.messages.addDefault("tpoffline.offline-location", "<red>Player is offline and location is unavailable.");
        this.messages.addDefault("tpoffline.teleported", "<green>Teleported to <#ffff00>%player%</#ffff00>");
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        if (args.length != 1) {
            player.sendMessage(this.messages.getMessageComponent("tpoffline.usage", new String[0]));
            return true;
        }
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[0]);
        Location loc = null;
        loc = target.isOnline() ? target.getPlayer().getLocation() : this.plugin.getLastLocation(target.getUniqueId());
        if (loc == null) {
            player.sendMessage(this.messages.getMessageComponent("tpoffline.offline-location", new String[0]));
        } else {
            player.teleport(loc);
            player.sendMessage(this.messages.getMessageComponent("tpoffline.teleported", "%player%", target.getName()));
        }
        return true;
    }
}

