/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.md_5.bungee.api.ChatColor;

public class ChatUtil {
    private static final Pattern HEX_PATTERN = Pattern.compile("&#([A-Fa-f0-9]{6})");

    public static String color(String message) {
        if (message == null || message.isEmpty()) {
            return "";
        }
        Matcher matcher = HEX_PATTERN.matcher(message);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String hexCode = matcher.group(1);
            String replacement = ChatColor.of((String)("#" + hexCode)).toString();
            matcher.appendReplacement(buffer, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(buffer);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)buffer.toString());
    }

    public static Component component(String message) {
        if (message == null || message.isEmpty()) {
            return Component.empty();
        }
        String parsed = message.replaceAll("&#([A-Fa-f0-9]{6})", "\u00a7x\u00a7$1".replaceAll("([A-Fa-f0-9])", "\u00a7$1"));
        parsed = ChatColor.translateAlternateColorCodes((char)'&', (String)parsed);
        return LegacyComponentSerializer.legacySection().deserialize(parsed);
    }

    public static String success(String msg) {
        return ChatUtil.color("&#1BFF00" + msg);
    }

    public static String error(String msg) {
        return ChatUtil.color("&#FF0000" + msg);
    }
}

