/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.util;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class FunMessages {
    private final Plugin plugin;
    private final File file;
    private FileConfiguration config;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();
    private static final Set<FunMessages> INSTANCES = new HashSet<FunMessages>();

    public FunMessages(Plugin plugin, String path) {
        this.plugin = plugin;
        this.file = new File(plugin.getDataFolder(), path);
        if (!this.file.exists()) {
            this.file.getParentFile().mkdirs();
            plugin.saveResource(path, false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        INSTANCES.add(this);
    }

    public void reload() {
        if (!this.file.exists()) {
            if (!this.file.getParentFile().exists()) {
                this.file.getParentFile().mkdirs();
            }
            this.plugin.saveResource(this.file.getName(), false);
        }
        try {
            this.config.load(this.file);
        }
        catch (IOException | InvalidConfigurationException e) {
            this.plugin.getLogger().severe("Could not reload " + this.file.getName() + "!");
            e.printStackTrace();
        }
    }

    public static void reloadAll() {
        for (FunMessages messages : INSTANCES) {
            messages.reload();
        }
    }

    public Component get(String path, String ... placeholders) {
        String msg = this.getConfig().getString(path, "<red>Missing message: " + path);
        if (placeholders != null && placeholders.length % 2 == 0) {
            for (int i = 0; i < placeholders.length; i += 2) {
                msg = msg.replace(placeholders[i], placeholders[i + 1]);
            }
        }
        return this.miniMessage.deserialize(msg);
    }

    public void addDefault(String path, Object value) {
        if (!this.config.contains(path)) {
            this.config.set(path, value);
            this.save();
        }
    }

    public Component get(String path) {
        String raw = this.config.getString(path, "<red>Missing message: " + path);
        return this.miniMessage.deserialize(raw);
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public void save() {
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save " + this.file.getName() + "!");
            e.printStackTrace();
        }
    }
}

