/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.util;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import serveressentials.serveressentials.ServerEssentials;

public class PlayerMessages {
    private final ServerEssentials plugin;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();
    private FileConfiguration config;
    private File file;
    private static final Set<PlayerMessages> INSTANCES = new HashSet<PlayerMessages>();

    public PlayerMessages(ServerEssentials plugin) {
        this.plugin = plugin;
        this.load();
        INSTANCES.add(this);
    }

    public void load() {
        this.file = new File(this.plugin.getDataFolder(), "messages/player.yml");
        if (!this.file.getParentFile().exists()) {
            this.file.getParentFile().mkdirs();
        }
        if (!this.file.exists()) {
            this.plugin.saveResource("messages/player.yml", false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public void reload() {
        if (this.file != null && this.file.exists()) {
            this.config = YamlConfiguration.loadConfiguration((File)this.file);
        } else {
            this.load();
        }
    }

    public static void reloadAll() {
        for (PlayerMessages messages : INSTANCES) {
            messages.reload();
        }
    }

    public void save() {
        try {
            if (this.file != null) {
                this.config.save(this.file);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addDefault(String path, String defaultMessage) {
        if (!this.config.contains(path)) {
            this.config.set(path, (Object)defaultMessage);
            this.save();
        }
    }

    public Component get(String path, String ... placeholders) {
        String msg = this.config.getString(path, "<red>Missing message for " + path);
        if (placeholders != null && placeholders.length % 2 == 0) {
            for (int i = 0; i < placeholders.length; i += 2) {
                msg = msg.replace(placeholders[i], placeholders[i + 1]);
            }
        }
        return this.miniMessage.deserialize(msg);
    }

    public FileConfiguration getConfig() {
        return this.config;
    }
}

