/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.common.base.Preconditions;
import java.util.Date;

class RateLimiter {
    private final int initialCapacity;
    private final double multiplier;
    private final int multiplierMillis;
    private final long startTimeMillis;
    private final int maximumRate;
    private int availableTokens;
    private long lastRefillTimeMillis;

    RateLimiter(int initialCapacity, double multiplier, int multiplierMillis, int maximumRate) {
        this(initialCapacity, multiplier, multiplierMillis, maximumRate, new Date().getTime());
    }

    RateLimiter(int initialCapacity, double multiplier, int multiplierMillis, int maximumRate, long startTimeMillis) {
        this.initialCapacity = initialCapacity;
        this.multiplier = multiplier;
        this.multiplierMillis = multiplierMillis;
        this.maximumRate = maximumRate;
        this.startTimeMillis = startTimeMillis;
        this.availableTokens = initialCapacity;
        this.lastRefillTimeMillis = startTimeMillis;
    }

    public int getInitialCapacity() {
        return this.initialCapacity;
    }

    public int getMaximumRate() {
        return this.maximumRate;
    }

    public boolean tryMakeRequest(int numOperations) {
        return this.tryMakeRequest(numOperations, new Date().getTime());
    }

    public boolean tryMakeRequest(int numOperations, long requestTimeMillis) {
        this.refillTokens(requestTimeMillis);
        if (numOperations <= this.availableTokens) {
            this.availableTokens -= numOperations;
            return true;
        }
        return false;
    }

    public long getNextRequestDelayMs(int numOperations) {
        return this.getNextRequestDelayMs(numOperations, new Date().getTime());
    }

    public long getNextRequestDelayMs(int numOperations, long requestTimeMillis) {
        if (numOperations < this.availableTokens) {
            return 0L;
        }
        int capacity = this.calculateCapacity(requestTimeMillis);
        if (capacity < numOperations) {
            return -1L;
        }
        int requiredTokens = numOperations - this.availableTokens;
        return (long)Math.ceil((double)(requiredTokens * 1000) / (double)capacity);
    }

    private void refillTokens(long requestTimeMillis) {
        Preconditions.checkArgument(requestTimeMillis >= this.lastRefillTimeMillis, "Request time should not be before the last token refill time");
        long elapsedTime = requestTimeMillis - this.lastRefillTimeMillis;
        int capacity = this.calculateCapacity(requestTimeMillis);
        int tokensToAdd = (int)(elapsedTime * (long)capacity / 1000L);
        if (tokensToAdd > 0) {
            this.availableTokens = Math.min(capacity, this.availableTokens + tokensToAdd);
            this.lastRefillTimeMillis = requestTimeMillis;
        }
    }

    public int calculateCapacity(long requestTimeMillis) {
        long millisElapsed = requestTimeMillis - this.startTimeMillis;
        int operationsPerSecond = Math.min((int)(Math.pow(this.multiplier, (int)(millisElapsed / (long)this.multiplierMillis)) * (double)this.initialCapacity), this.maximumRate);
        return operationsPerSecond;
    }
}

