/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public abstract class UserImportHash {
    private final String name;

    protected UserImportHash(String name) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(name));
        this.name = name;
    }

    final Map<String, Object> getProperties() {
        return ImmutableMap.builder().put("hashAlgorithm", this.name).putAll(this.getOptions()).build();
    }

    protected abstract Map<String, Object> getOptions();
}

