/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.hash;

import com.google.common.collect.ImmutableMap;
import com.google.firebase.auth.UserImportHash;
import java.util.Map;

public final class StandardScrypt
extends UserImportHash {
    private final int derivedKeyLength;
    private final int blockSize;
    private final int parallelization;
    private final int memoryCost;

    private StandardScrypt(Builder builder) {
        super("STANDARD_SCRYPT");
        this.derivedKeyLength = builder.derivedKeyLength;
        this.blockSize = builder.blockSize;
        this.parallelization = builder.parallelization;
        this.memoryCost = builder.memoryCost;
    }

    @Override
    protected Map<String, Object> getOptions() {
        return ImmutableMap.of("dkLen", this.derivedKeyLength, "blockSize", this.blockSize, "parallelization", this.parallelization, "memoryCost", this.memoryCost);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int derivedKeyLength;
        private int blockSize;
        private int parallelization;
        private int memoryCost;

        private Builder() {
        }

        public Builder setDerivedKeyLength(int derivedKeyLength) {
            this.derivedKeyLength = derivedKeyLength;
            return this;
        }

        public Builder setBlockSize(int blockSize) {
            this.blockSize = blockSize;
            return this;
        }

        public Builder setParallelization(int parallelization) {
            this.parallelization = parallelization;
            return this;
        }

        public Builder setMemoryCost(int memoryCost) {
            this.memoryCost = memoryCost;
            return this;
        }

        public StandardScrypt build() {
            return new StandardScrypt(this);
        }
    }
}

