/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.cloud;

import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.firebase.FirebaseApp;
import com.google.firebase.ImplFirebaseTrampolines;
import com.google.firebase.internal.FirebaseService;

public class StorageClient {
    private final FirebaseApp app;
    private final Storage storage;
    private static final String SERVICE_ID = StorageClient.class.getName();

    @VisibleForTesting
    StorageClient(FirebaseApp app, Storage storage) {
        this.app = Preconditions.checkNotNull(app, "FirebaseApp must not be null");
        this.storage = Preconditions.checkNotNull(storage, "Storage must not be null");
    }

    public static StorageClient getInstance() {
        return StorageClient.getInstance(FirebaseApp.getInstance());
    }

    public static synchronized StorageClient getInstance(FirebaseApp app) {
        StorageClientService service = ImplFirebaseTrampolines.getService(app, SERVICE_ID, StorageClientService.class);
        if (service == null) {
            Storage storage = (Storage)((StorageOptions.Builder)StorageOptions.newBuilder().setCredentials(ImplFirebaseTrampolines.getCredentials(app))).build().getService();
            StorageClient client = new StorageClient(app, storage);
            service = ImplFirebaseTrampolines.addService(app, new StorageClientService(client));
        }
        return (StorageClient)service.getInstance();
    }

    public Bucket bucket() {
        return this.bucket(this.app.getOptions().getStorageBucket());
    }

    public Bucket bucket(String name) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(name), "Bucket name not specified. Specify the bucket name via the storageBucket option when initializing the app, or specify the bucket name explicitly when calling the getBucket() method.");
        Bucket bucket = this.storage.get(name, new Storage.BucketGetOption[0]);
        Preconditions.checkArgument(bucket != null, "Bucket " + name + " does not exist.");
        return bucket;
    }

    private static class StorageClientService
    extends FirebaseService<StorageClient> {
        StorageClientService(StorageClient client) {
            super(SERVICE_ID, client);
        }
    }
}

