/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JsonMapper {
    private static final Gson GSON = new GsonBuilder().serializeNulls().create();

    public static String serializeJson(Object object) throws IOException {
        try {
            return GSON.toJson(object);
        }
        catch (JsonSyntaxException e) {
            throw new IOException(e);
        }
    }

    public static Map<String, Object> parseJson(String json) throws IOException {
        try {
            JsonReader jsonReader = new JsonReader(new StringReader(json));
            return JsonMapper.unwrapJsonObject(jsonReader);
        }
        catch (JsonSyntaxException | IllegalStateException e) {
            throw new IOException(e);
        }
    }

    public static Object parseJsonValue(String json) throws IOException {
        try {
            JsonReader jsonReader = new JsonReader(new StringReader(json));
            jsonReader.setLenient(true);
            return JsonMapper.unwrapJson(jsonReader);
        }
        catch (JsonSyntaxException | IllegalStateException e) {
            throw new IOException(e);
        }
    }

    private static Map<String, Object> unwrapJsonObject(JsonReader jsonReader) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        jsonReader.beginObject();
        while (jsonReader.peek() != JsonToken.END_OBJECT) {
            String key = jsonReader.nextName();
            map.put(key, JsonMapper.unwrapJson(jsonReader));
        }
        jsonReader.endObject();
        return map;
    }

    private static List<Object> unwrapJsonArray(JsonReader jsonReader) throws IOException {
        ArrayList<Object> list = new ArrayList<Object>();
        jsonReader.beginArray();
        while (jsonReader.peek() != JsonToken.END_ARRAY) {
            list.add(JsonMapper.unwrapJson(jsonReader));
        }
        jsonReader.endArray();
        return list;
    }

    private static Object unwrapJson(JsonReader jsonReader) throws IOException {
        switch (jsonReader.peek()) {
            case BEGIN_ARRAY: {
                return JsonMapper.unwrapJsonArray(jsonReader);
            }
            case BEGIN_OBJECT: {
                return JsonMapper.unwrapJsonObject(jsonReader);
            }
            case STRING: {
                return jsonReader.nextString();
            }
            case NUMBER: {
                String value = jsonReader.nextString();
                if (value.matches("-?\\d+")) {
                    long longValue = Long.parseLong(value);
                    if (longValue <= Integer.MAX_VALUE && longValue >= Integer.MIN_VALUE) {
                        return (int)longValue;
                    }
                    return Long.valueOf(value);
                }
                return Double.parseDouble(value);
            }
            case BOOLEAN: {
                return jsonReader.nextBoolean();
            }
            case NULL: {
                jsonReader.nextNull();
                return null;
            }
        }
        throw new IllegalStateException("unknown type " + (Object)((Object)jsonReader.peek()));
    }
}

