/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.Fun;

import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Bee;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import serveressentials.serveressentials.util.FunMessages;

public class BeezookaCommand
implements CommandExecutor,
TabCompleter {
    private final FunMessages messages;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();
    private final double defaultVelocity;

    public BeezookaCommand(FunMessages messages) {
        this.messages = messages;
        messages.addDefault("Beezooka.PlayerOnly", "<red>Only players can use this command!");
        messages.addDefault("Beezooka.Fired", "<green>Beezooka fired with velocity {velocity}!");
        messages.addDefault("Beezooka.Name", "<yellow>Beezooka Bee!");
        messages.addDefault("Beezooka.Velocity", 2.5);
        this.defaultVelocity = messages.getConfig().getDouble("Beezooka.Velocity", 2.5);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.messages.get("Beezooka.PlayerOnly"));
            return true;
        }
        Player player = (Player)sender;
        double velocity = this.defaultVelocity;
        if (args.length > 0) {
            try {
                velocity = Double.parseDouble(args[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Bee bee = (Bee)player.getWorld().spawnEntity(player.getEyeLocation().add(player.getLocation().getDirection()), EntityType.BEE);
        Vector direction = player.getLocation().getDirection().multiply(velocity);
        bee.setVelocity(direction);
        bee.setAnger(0);
        String nameRaw = this.messages.getConfig().getString("Beezooka.Name", "<yellow>Beezooka Bee!");
        Object nameComponent = this.miniMessage.deserialize(nameRaw);
        bee.customName(nameComponent);
        bee.setCustomNameVisible(true);
        String firedRaw = this.messages.getConfig().getString("Beezooka.Fired", "<green>Beezooka fired!");
        firedRaw = firedRaw.replace("{velocity}", String.valueOf(velocity));
        player.sendMessage(this.miniMessage.deserialize(firedRaw));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            ArrayList<String> suggestions = new ArrayList<String>();
            for (int i = 1; i <= 5; ++i) {
                suggestions.add(String.valueOf(i));
            }
            return suggestions;
        }
        return null;
    }
}

