/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.Fun;

import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import serveressentials.serveressentials.util.FunMessages;

public class KittyCannonCommand
implements CommandExecutor,
TabCompleter {
    private final FunMessages messages;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();
    private final double defaultVelocity;

    public KittyCannonCommand(FunMessages messages) {
        this.messages = messages;
        messages.addDefault("KittyCannon.PlayerOnly", "<red>Only players can use this command!");
        messages.addDefault("KittyCannon.Fired", "<green>Kitty cannon fired with velocity {velocity}!");
        messages.addDefault("KittyCannon.Name", "<light_purple>Kitty Cannon!");
        messages.addDefault("KittyCannon.Velocity", 2.0);
        this.defaultVelocity = messages.getConfig().getDouble("KittyCannon.Velocity", 2.0);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.messages.get("KittyCannon.PlayerOnly"));
            return true;
        }
        Player player = (Player)sender;
        double velocity = this.defaultVelocity;
        if (args.length > 0) {
            try {
                velocity = Double.parseDouble(args[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        LivingEntity kitty = (LivingEntity)player.getWorld().spawnEntity(player.getEyeLocation().add(player.getLocation().getDirection()), EntityType.CAT);
        Vector direction = player.getLocation().getDirection().multiply(velocity);
        kitty.setVelocity(direction);
        String nameRaw = this.messages.getConfig().getString("KittyCannon.Name");
        if (nameRaw == null) {
            nameRaw = "<light_purple>Kitty Cannon!";
        }
        Object nameComponent = this.miniMessage.deserialize(nameRaw);
        kitty.customName(nameComponent);
        kitty.setCustomNameVisible(true);
        String firedRaw = this.messages.getConfig().getString("KittyCannon.Fired", "<green>Kitty cannon fired!");
        firedRaw = firedRaw.replace("{velocity}", String.valueOf(velocity));
        player.sendMessage(this.miniMessage.deserialize(firedRaw));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            ArrayList<String> suggestions = new ArrayList<String>();
            for (int i = 1; i <= 5; ++i) {
                suggestions.add(String.valueOf(i));
            }
            return suggestions;
        }
        return null;
    }
}

