/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.Managers;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class AFKManager
implements Listener {
    private final Plugin plugin;
    private final Map<UUID, Long> lastActivity = new HashMap<UUID, Long>();
    private final Set<UUID> afkPlayers = new HashSet<UUID>();
    private final Map<UUID, BossBar> bossBars = new HashMap<UUID, BossBar>();
    private File configFile;
    private YamlConfiguration config;
    private final MiniMessage mm = MiniMessage.miniMessage();

    public AFKManager(Plugin plugin) {
        this.plugin = plugin;
        this.loadConfig();
        Bukkit.getPluginManager().registerEvents((Listener)this, plugin);
        Bukkit.getScheduler().runTaskTimer(plugin, this::checkAFK, 20L, 20L);
    }

    private void loadConfig() {
        this.configFile = new File(String.valueOf(this.plugin.getDataFolder()) + "/config/afk", "afk.yml");
        if (!this.configFile.exists()) {
            this.configFile.getParentFile().mkdirs();
            this.plugin.saveResource("config/afk/afk.yml", false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
    }

    public void reloadConfig() {
        try {
            this.config.save(this.configFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
    }

    private void updateActivity(Player player) {
        this.lastActivity.put(player.getUniqueId(), System.currentTimeMillis());
        if (this.afkPlayers.remove(player.getUniqueId())) {
            this.sendMessage(player, "messages.back", true);
            this.removeBossBar(player);
        }
    }

    private void checkAFK() {
        long timeout = this.config.getLong("settings.timeout-seconds") * 1000L;
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!this.lastActivity.containsKey(player.getUniqueId())) {
                this.lastActivity.put(player.getUniqueId(), System.currentTimeMillis());
                continue;
            }
            if (this.afkPlayers.contains(player.getUniqueId()) || System.currentTimeMillis() - this.lastActivity.get(player.getUniqueId()) < timeout) continue;
            this.setAFK(player, true);
        }
    }

    public void setAFK(Player player, boolean afk) {
        if (afk) {
            String worldName;
            World world;
            this.afkPlayers.add(player.getUniqueId());
            this.sendMessage(player, "messages.afk", true);
            this.showBossBar(player);
            if (this.config.getBoolean("settings.kick-on-afk")) {
                player.kick(this.mm.deserialize(this.config.getString("messages.kick")));
            }
            if (this.config.getBoolean("settings.teleport.enabled") && (world = Bukkit.getWorld((String)(worldName = this.config.getString("settings.teleport.world")))) != null) {
                double x = this.config.getDouble("settings.teleport.x");
                double y = this.config.getDouble("settings.teleport.y");
                double z = this.config.getDouble("settings.teleport.z");
                player.teleport(new Location(world, x, y, z));
            }
            if (this.config.getBoolean("settings.sounds.enabled")) {
                player.playSound(player.getLocation(), Sound.valueOf((String)this.config.getString("settings.sounds.sound")), 1.0f, 1.0f);
            }
            if (this.config.getBoolean("settings.particles.enabled")) {
                player.getWorld().spawnParticle(Particle.valueOf((String)this.config.getString("settings.particles.particle")), player.getLocation(), 30, 0.5, 1.0, 0.5, 0.01);
            }
        } else {
            this.afkPlayers.remove(player.getUniqueId());
            this.sendMessage(player, "messages.back", true);
            this.removeBossBar(player);
        }
    }

    private void sendMessage(Player player, String path, boolean broadcast) {
        String msg = this.config.getString(path);
        if (msg == null || msg.isEmpty()) {
            return;
        }
        Object component = this.mm.deserialize(msg.replace("%player%", player.getName()));
        if (broadcast && this.config.getBoolean("settings.broadcast.enabled")) {
            Bukkit.broadcast(component);
        } else {
            player.sendMessage(component);
        }
    }

    private void showBossBar(Player player) {
        if (!this.config.getBoolean("settings.bossbar.enabled")) {
            return;
        }
        String text = this.config.getString("settings.bossbar.text").replace("%player%", player.getName());
        BossBar.Color color = BossBar.Color.valueOf(this.config.getString("settings.bossbar.color"));
        BossBar.Overlay overlay = BossBar.Overlay.valueOf(this.config.getString("settings.bossbar.style"));
        BossBar bossBar = BossBar.bossBar(this.mm.deserialize(text), 1.0f, color, overlay);
        this.bossBars.put(player.getUniqueId(), bossBar);
        player.showBossBar(bossBar);
    }

    private void removeBossBar(Player player) {
        if (this.bossBars.containsKey(player.getUniqueId())) {
            player.hideBossBar(this.bossBars.get(player.getUniqueId()));
            this.bossBars.remove(player.getUniqueId());
        }
    }

    @EventHandler
    public void onMove(PlayerMoveEvent e) {
        if (!e.getFrom().toVector().equals((Object)e.getTo().toVector())) {
            this.updateActivity(e.getPlayer());
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent e) {
        this.lastActivity.remove(e.getPlayer().getUniqueId());
        this.afkPlayers.remove(e.getPlayer().getUniqueId());
        this.removeBossBar(e.getPlayer());
    }

    public boolean isAFK(Player player) {
        return this.afkPlayers.contains(player.getUniqueId());
    }

    public Set<String> getAFKPlayers() {
        HashSet<String> names = new HashSet<String>();
        for (UUID id : this.afkPlayers) {
            Player p = Bukkit.getPlayer((UUID)id);
            if (p == null) continue;
            names.add(p.getName());
        }
        return names;
    }
}

