/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.Managers;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class ConsoleCommandManager {
    private final JavaPlugin plugin;
    private FileConfiguration config;
    private File configFile;

    public ConsoleCommandManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.loadConfig();
    }

    private void loadConfig() {
        File configFolder;
        File pluginFolder = this.plugin.getDataFolder();
        if (!pluginFolder.exists()) {
            pluginFolder.mkdirs();
        }
        if (!(configFolder = new File(pluginFolder, "config/ConsoleCommands")).exists()) {
            configFolder.mkdirs();
        }
        this.configFile = new File(configFolder, "consolecommands.yml");
        if (!this.configFile.exists()) {
            try {
                this.configFile.createNewFile();
                YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((File)this.configFile);
                defaultConfig.set("example.console", List.of("say %player% executed a command!"));
                defaultConfig.set("example.player", List.of("give %player% minecraft:stone 1"));
                defaultConfig.save(this.configFile);
            }
            catch (IOException e) {
                Bukkit.getLogger().severe("[ServerEssentials] Could not create consolecommands.yml!");
                e.printStackTrace();
            }
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
    }

    public void runCommands(String path, Player player) {
        if (this.config.contains(path + ".console")) {
            List consoleCmds = this.config.getStringList(path + ".console");
            for (String cmd : consoleCmds) {
                if (cmd == null || cmd.trim().isEmpty()) continue;
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)cmd.replace("%player%", player.getName()));
            }
        }
        if (this.config.contains(path + ".player")) {
            List playerCmds = this.config.getStringList(path + ".player");
            for (String cmd : playerCmds) {
                if (cmd == null || cmd.trim().isEmpty()) continue;
                player.performCommand(cmd.replace("%player%", player.getName()));
            }
        }
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public void reloadConfig() {
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
    }
}

