/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.Rtp;

import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import serveressentials.serveressentials.ServerEssentials;
import serveressentials.serveressentials.config.RTPConfig;
import serveressentials.serveressentials.util.RTPMessages;

public class RTPCommand
implements CommandExecutor {
    private final ServerEssentials plugin;
    private final RTPMessages messages;

    public RTPCommand(ServerEssentials plugin) {
        this.plugin = plugin;
        this.messages = new RTPMessages(plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 1 && args[0].equalsIgnoreCase("reload")) {
            if (!sender.hasPermission("rtp.reload")) {
                sender.sendMessage(this.messages.get("no-permission", new String[0]));
                return true;
            }
            RTPConfig.load();
            this.messages.reload();
            sender.sendMessage(this.messages.get("reload-success", new String[0]));
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.messages.get("only-player", new String[0]));
            return true;
        }
        Player player = (Player)sender;
        Component title = this.messages.get("gui.title", new String[0]);
        Inventory gui = Bukkit.createInventory(null, (int)9, (Component)title);
        ItemStack overworld = new ItemStack(Material.GRASS_BLOCK);
        ItemMeta meta1 = overworld.getItemMeta();
        meta1.displayName(this.messages.get("gui.overworld.name", new String[0]));
        meta1.lore(this.messages.getList("gui.overworld.lore", new String[0]));
        overworld.setItemMeta(meta1);
        gui.setItem(2, overworld);
        ItemStack nether = new ItemStack(Material.NETHERRACK);
        ItemMeta meta2 = nether.getItemMeta();
        meta2.displayName(this.messages.get("gui.nether.name", new String[0]));
        meta2.lore(this.messages.getList("gui.nether.lore", new String[0]));
        nether.setItemMeta(meta2);
        gui.setItem(4, nether);
        ItemStack theEnd = new ItemStack(Material.END_STONE);
        ItemMeta meta3 = theEnd.getItemMeta();
        meta3.displayName(this.messages.get("gui.end.name", new String[0]));
        meta3.lore(this.messages.getList("gui.end.lore", new String[0]));
        theEnd.setItemMeta(meta3);
        gui.setItem(6, theEnd);
        player.openInventory(gui);
        return true;
    }
}

