/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.Rtp;

import java.io.File;
import java.io.IOException;
import java.util.Random;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import serveressentials.serveressentials.Managers.BackManager;
import serveressentials.serveressentials.Managers.CooldownManager;
import serveressentials.serveressentials.ServerEssentials;
import serveressentials.serveressentials.util.RTPMessages;

public class RTPListener
implements Listener {
    private final ServerEssentials plugin;
    private final RTPMessages messages;
    private final Random random = new Random();
    private final MiniMessage miniMessage = MiniMessage.miniMessage();
    private final File rtpLogFile;
    private final YamlConfiguration rtpLog;
    private final File rtpConfigFile;
    private final YamlConfiguration rtpConfig;

    public RTPListener(ServerEssentials plugin) {
        this.plugin = plugin;
        this.messages = new RTPMessages(plugin);
        this.rtpLogFile = new File(plugin.getDataFolder(), "rtplocations.yml");
        this.rtpLog = YamlConfiguration.loadConfiguration((File)this.rtpLogFile);
        this.rtpConfigFile = new File(plugin.getDataFolder(), "config/rtp/rtpconfig.yml");
        if (!this.rtpConfigFile.exists()) {
            plugin.saveResource("config/rtp/rtpconfig.yml", false);
        }
        this.rtpConfig = YamlConfiguration.loadConfiguration((File)this.rtpConfigFile);
    }

    private boolean isWorldEnabled(String worldName) {
        return this.rtpConfig.getBoolean(worldName + ".enabled", true);
    }

    private int getCooldown(String worldName) {
        return this.rtpConfig.getInt(worldName + ".cooldown", 60);
    }

    private int getMinRadius(String worldName) {
        return this.rtpConfig.getInt(worldName + ".min-radius", 100);
    }

    private int getMaxRadius(String worldName) {
        return this.rtpConfig.getInt(worldName + ".max-radius", 1000);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        int y;
        int z;
        int x;
        World world;
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        Component expectedTitle = this.messages.get("gui.title", new String[0]);
        if (!event.getView().title().equals(expectedTitle)) {
            return;
        }
        event.setCancelled(true);
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || clicked.getType() == Material.AIR) {
            return;
        }
        switch (clicked.getType()) {
            case GRASS_BLOCK: {
                world = Bukkit.getWorld((String)"world");
                break;
            }
            case NETHERRACK: {
                world = Bukkit.getWorld((String)"world_nether");
                break;
            }
            case END_STONE: {
                world = Bukkit.getWorld((String)"world_the_end");
                break;
            }
            default: {
                return;
            }
        }
        if (world == null) {
            player.sendMessage(this.messages.get("world-not-loaded", new String[0]));
            return;
        }
        if (!this.isWorldEnabled(world.getName())) {
            player.sendMessage(this.messages.get("world-disabled", new String[0]));
            return;
        }
        if (CooldownManager.isOnCooldown(player.getUniqueId())) {
            long remaining = CooldownManager.getRemaining(player.getUniqueId());
            player.sendMessage(this.messages.get("cooldown", "{seconds}", String.valueOf(remaining)));
            return;
        }
        CooldownManager.setCooldown(player.getUniqueId(), this.getCooldown(world.getName()));
        int min2 = this.getMinRadius(world.getName());
        int max = this.getMaxRadius(world.getName());
        if (world.getEnvironment() == World.Environment.THE_END) {
            int distance = min2 + this.random.nextInt(max - min2 + 1);
            double angle = this.random.nextDouble() * 2.0 * Math.PI;
            x = (int)(Math.cos(angle) * (double)distance);
            z = (int)(Math.sin(angle) * (double)distance);
            y = world.getHighestBlockYAt(x, z) + 1;
        } else if (world.getEnvironment() == World.Environment.NETHER) {
            x = this.random.nextInt(max - min2 + 1) + min2;
            x *= this.random.nextBoolean() ? 1 : -1;
            z = this.random.nextInt(max - min2 + 1) + min2;
            z *= this.random.nextBoolean() ? 1 : -1;
            y = 64;
        } else {
            x = this.random.nextInt(max - min2 + 1) + min2;
            z = this.random.nextInt(max - min2 + 1) + min2;
            y = world.getHighestBlockYAt(x *= this.random.nextBoolean() ? 1 : -1, z *= this.random.nextBoolean() ? 1 : -1) + 1;
        }
        Location loc = new Location(world, (double)x + 0.5, (double)y, (double)z + 0.5);
        BackManager.setLastLocation(player.getUniqueId(), player.getLocation());
        player.closeInventory();
        player.getWorld().spawnParticle(Particle.PORTAL, player.getLocation(), 100, 1.0, 1.0, 1.0);
        player.playSound(player.getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            player.teleport(loc);
            player.sendMessage(this.messages.get("teleport-success", "{world}", world.getName()));
            world.spawnParticle(Particle.PORTAL, loc, 100, 1.0, 1.0, 1.0);
            world.playSound(loc, Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
        }, 40L);
        this.rtpLog.set(player.getName(), (Object)(world.getName() + ": " + x + " " + y + " " + z));
        try {
            this.rtpLog.save(this.rtpLogFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @EventHandler
    public void onDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        BackManager.setLastLocation(player.getUniqueId(), player.getLocation());
    }
}

