/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.auction;

import java.io.File;
import java.io.IOException;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import serveressentials.serveressentials.ServerEssentials;

public class AuctionMessagesManager {
    private final ServerEssentials plugin;
    private File messagesFile;
    private FileConfiguration messagesConfig;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();

    public AuctionMessagesManager(ServerEssentials plugin) {
        this.plugin = plugin;
        this.loadMessages();
    }

    public void loadMessages() {
        this.messagesFile = new File(this.plugin.getDataFolder(), "messages/auction.yml");
        if (!this.messagesFile.getParentFile().exists()) {
            this.messagesFile.getParentFile().mkdirs();
        }
        if (!this.messagesFile.exists()) {
            this.plugin.saveResource("messages/auction.yml", false);
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
    }

    public Component getMessage(String path, String ... placeholders) {
        String msg = this.messagesConfig.getString(path, "<red>Missing message for " + path);
        if (placeholders != null && placeholders.length % 2 == 0) {
            for (int i = 0; i < placeholders.length; i += 2) {
                msg = msg.replace(placeholders[i], placeholders[i + 1]);
            }
        }
        return this.miniMessage.deserialize(msg);
    }

    public void addDefault(String path, String defaultMessage) {
        if (!this.messagesConfig.contains(path)) {
            this.messagesConfig.set(path, (Object)defaultMessage);
            this.save();
        }
    }

    public void save() {
        try {
            this.messagesConfig.save(this.messagesFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public FileConfiguration getConfig() {
        return this.messagesConfig;
    }
}

