/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.config;

import java.io.File;
import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class RTPConfig {
    private static final File file = new File("plugins/ServerEssentials/config/rtp", "rtpconfig.yml");
    private static FileConfiguration config;

    public static void load() {
        File parentFolder = file.getParentFile();
        if (!parentFolder.exists()) {
            parentFolder.mkdirs();
        }
        if (!file.exists()) {
            try {
                file.createNewFile();
                config = YamlConfiguration.loadConfiguration((File)file);
                for (World world : Bukkit.getWorlds()) {
                    String name = world.getName();
                    config.set(name + ".enabled", (Object)true);
                    config.set(name + ".cooldown", (Object)60);
                    config.set(name + ".min-radius", (Object)500);
                    config.set(name + ".max-radius", (Object)2000);
                }
                config.save(file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            config = YamlConfiguration.loadConfiguration((File)file);
        }
    }

    public static boolean isEnabled(String world) {
        return config.getBoolean(world + ".enabled", true);
    }

    public static int getCooldown(String world) {
        return config.getInt(world + ".cooldown", 60);
    }

    public static int getMinRadius(String world) {
        return config.getInt(world + ".min-radius", 500);
    }

    public static int getMaxRadius(String world) {
        return config.getInt(world + ".max-radius", 2000);
    }
}

